---
name: securityclaw-skill
description: Security-first skill auditing and quarantine for OpenClaw skills. Use when installing new skills, reviewing skills from unknown sources, scanning skills for prompt injection/exfiltration/supply-chain risks, or when a bot suspects a skill is malicious. Guides static + optional sandbox checks, quarantines suspicious skills, and produces an owner-action checklist (Delete / Report / Allow / Scan all).
---

# SecurityClaw (Skill Scanner)

## Use the scanner script

Run the scanner (read-only by default):

```bash
python3 scripts/securityclaw_scan.py --skills-dir ~/.openclaw/skills --out report.json
```

Quarantine anything suspicious (moves folders, no deletion):

```bash
python3 scripts/securityclaw_scan.py --skills-dir ~/.openclaw/skills --quarantine-dir ~/.openclaw/skills-quarantine --quarantine --out report.json
```

## What to do when findings exist

If the report shows `severity >= high` for any skill:

1) **Do not execute** the skill.
2) **Quarantine** the skill folder.
3) **Notify the owner** with:
   - skill name
   - top reasons + file/line locations
   - recommended action
4) Await owner instruction:
   - **Delete**: remove quarantined skill
   - **Report**: prepare public report / IOCs (no secrets)
   - **Allow**: add allowlist entry and restore
   - **Scan all**: deep scan everything

## Optional: sandbox/dynamic checks (advanced)

Dynamic checks are optional and should run only after owner approval.

- Prefer running unknown code with:
  - no network egress
  - read-only filesystem except a temp workspace
  - no access to OpenClaw config/secrets

See `references/sandboxing.md`.

## Files

- `scripts/securityclaw_scan.py` — main scanner + quarantine
- `references/rules.md` — rule catalog (what we flag and why)
- `references/sandboxing.md` — safe sandbox strategy + what to avoid
