---
name: security-scanner
description: Automated security scanning and vulnerability detection for web applications, APIs, and infrastructure. Use when you need to scan targets for vulnerabilities, check SSL certificates, find open ports, detect misconfigurations, or perform security audits. Integrates with nmap, nuclei, and other security tools.
---

# Security Scanner

Automated security scanning toolkit for penetration testing and vulnerability assessment.

## Quick Start

### Port Scan
```bash
nmap -sV -sC -oN scan.txt TARGET
```

### Vulnerability Scan
```bash
nuclei -u TARGET -o results.txt
```

### SSL Check
```bash
sslscan TARGET
```

## Scan Types

### 1. Quick Recon
Fast initial scan for live hosts and open ports:
```bash
nmap -sn -T4 SUBNET  # Host discovery
nmap -F TARGET       # Fast port scan (top 100)
```

### 2. Full Port Scan
Comprehensive port and service detection:
```bash
nmap -p- -sV -sC -A TARGET -oN full_scan.txt
```

### 3. Web Application Scan
```bash
nuclei -u https://TARGET -t cves/ -t vulnerabilities/ -o web_vulns.txt
nikto -h TARGET -o nikto_report.txt
```

### 4. SSL/TLS Analysis
```bash
sslscan TARGET
testssl.sh TARGET
```

## Output

Save reports to `reports/security-scan-YYYY-MM-DD.md` with:
- Target information
- Open ports and services
- Vulnerabilities found (severity rated)
- Recommendations

## Ethics

- Only scan authorized targets
- Get written permission before testing
- Report vulnerabilities responsibly
- Never exploit without authorization
