# VPS hardening checklist (OpenClaw workshop level)

This is the "secure enough" baseline for running OpenClaw on a VPS.

## 0) First, prevent lockouts
- Confirm how the user connects (SSH from home IP, Tailnet, Hostinger console).
- Confirm whether they can access Hostinger web console as a fallback.
- Before changing SSH or firewall, make a rollback plan.

## 1) Network exposure (biggest risk)
- Do not expose the OpenClaw gateway/UI to the public internet.
- Prefer Tailnet/VPN access (Tailscale/WireGuard).
- If public access is unavoidable, use strict allowlist and strong auth.

## 2) SSH basics
- Key-only auth. Disable password auth.
- Disable root login (use sudo user).
- Rate limit / brute force protection (fail2ban).
- Optional: change SSH port (not a magic fix, but reduces noise).

## 3) Firewall
- Default deny incoming.
- Only allow:
  - SSH (from allowlisted IPs if possible)
  - Anything else you explicitly need

## 4) Updates
- Enable automatic security updates.
- Reboot cadence (weekly or as needed for kernel updates).

## 5) Secrets
- Keep API keys/tokens in environment variables.
- Restrict permissions on any secret files (owner read/write only).
- Never commit secrets to git.

## 6) OpenClaw-specific
- Restrict DM policies (allowlist users and actions).
- Enable sandbox mode for risky tasks.
- Limit enabled tools to only what is needed.
- Enable audit/session logging.

## 7) Prompt injection baseline
- Treat external content as untrusted.
- Summarize first. Ask before running commands or sending messages.
- Watch for override language and obfuscation (base64, unicode control chars).
