#!/bin/bash
# 统计脚本

WORKSPACE="/root/clawd"

echo "📊 安全记忆系统统计信息"
echo ""

# 百度Embedding统计
echo "🌐 百度Embedding系统:"
python3 -c "
import sys
sys.path.append('/root/clawd/skills/memory-baidu-embedding-db')
from memory_baidu_embedding_db import MemoryBaiduEmbeddingDB

try:
    db = MemoryBaiduEmbeddingDB()
    stats = db.get_statistics()
    print(f'  总记忆数: {stats[\"total_memories\"]}')
    print(f'  标签种类: {len(stats[\"tag_distribution\"])} 种')
    print(f'  时间跨度: {stats[\"earliest_memory\"]} 到 {stats[\"latest_memory\"]}')
except Exception as e:
    print(f'  状态: 异常 ({str(e)})')
"

# 文件统计
echo ""
echo "📁 文件系统统计:"
MEMORY_SIZE=$(stat -c%s "$WORKSPACE/MEMORY.md" 2>/dev/null || echo 0)
SESSION_SIZE=$(stat -c%s "$WORKSPACE/SESSION-STATE.md" 2>/dev/null || echo 0)
DAILY_COUNT=$(ls "$WORKSPACE/memory/"*.md 2>/dev/null | wc -l || echo 0)

echo "  MEMORY.md 大小: $MEMORY_SIZE 字节"
echo "  SESSION-STATE.md 大小: $SESSION_SIZE 字节"
echo "  每日日志数量: $DAILY_COUNT 个"

# Git Notes统计
echo ""
echo "📁 Git Notes统计:"
if [ -d "$WORKSPACE/.git" ]; then
    NOTES_COUNT=$(python3 /root/clawd/skills/git-notes-memory/memory.py -p "$WORKSPACE" recall 2>/dev/null | grep -c '{' || echo 0)
    echo "  记忆条目数: $NOTES_COUNT 个"
else
    echo "  记忆条目数: 未初始化 (Git仓库未设置)"
fi

echo ""
echo "🔒 安全状态:"
echo "  存储位置: 本地设备"
echo "  数据上传: 无"
echo "  访问控制: 本地访问"
echo "  隐私保护: 最高级别"