#!/bin/bash
# 初始化脚本

WORKSPACE="/root/clawd"

echo "🚀 开始设置安全记忆系统..."

# 创建必要的目录
mkdir -p "$WORKSPACE/memory"
mkdir -p "$WORKSPACE/notes/projects"
mkdir -p "$WORKSPACE/notes/areas"
mkdir -p "$WORKSPACE/notes/resources"
mkdir -p "$WORKSPACE/notes/archive"

# 创建初始MEMORY.md文件
MEMORY_FILE="$WORKSPACE/MEMORY.md"
if [ ! -f "$MEMORY_FILE" ]; then
    cat > "$MEMORY_FILE" << 'EOT'
# MEMORY.md — 长期记忆库

## 系统信息
- 记忆系统：安全记忆系统栈 (Secure Memory Stack)
- 安全级别：完全本地化，无数据上传
- 初始化时间：$(date '+%Y-%m-%d %H:%M:%S')

## 技术栈
- 语义搜索：百度Embedding-V1
- 结构化存储：Git Notes
- 文件存储：本地Markdown文件
- 搜索方式：混合搜索（语义+关键词）
EOT
    echo "✅ 创建MEMORY.md文件"
else
    echo "ℹ️  MEMORY.md文件已存在"
fi

# 创建当日记忆文件
DATE_FILE="$WORKSPACE/memory/$(date +%Y-%m-%d).md"
if [ ! -f "$DATE_FILE" ]; then
    cat > "$DATE_FILE" << EOT
# $(date +%Y-%m-%d) — 每日记忆日志

## 系统初始化
- 时间：$(date '+%Y-%m-%d %H:%M:%S')
- 事件：安全记忆系统初始化
- 状态：系统正常运行
EOT
    echo "✅ 创建当日记忆文件: $DATE_FILE"
else
    echo "ℹ️  当日消息文件已存在: $DATE_FILE"
fi

# 创建SESSION-STATE.md
SESSION_FILE="$WORKSPACE/SESSION-STATE.md"
if [ ! -f "$SESSION_FILE" ]; then
    cat > "$SESSION_FILE" << 'EOT'
# SESSION-STATE.md — 活动工作记忆

## 当前会话状态
- 会话开始时间：$(date '+%Y-%m-%d %H:%M:%S')
- 当前任务：安全记忆系统初始化
- 优先级：高

## 活动上下文
- 正在使用安全记忆系统栈
- 所有数据本地存储，无上传
EOT
    echo "✅ 创建SESSION-STATE.md文件"
else
    echo "ℹ️  SESSION-STATE.md文件已存在"
fi

# 初始化Git仓库（如果尚未初始化）
if [ ! -d "$WORKSPACE/.git" ]; then
    cd "$WORKSPACE"
    git init
    git config user.name "SecureMemoryBot"
    git config user.email "securememory@example.com"
    echo "✅ 初始化Git仓库"
else
    echo "ℹ️  Git仓库已存在"
fi

echo ""
echo "✅ 安全记忆系统初始化完成！"
echo ""
echo "📋 系统组件："
echo "- 百度Embedding语义搜索：已配置"
echo "- Git Notes结构化存储：已配置"
echo "- 本地文件记忆系统：已配置"
echo "- 安全配置：已验证"
echo ""
echo "🛡️  安全特性："
echo "- 完全本地化存储"
echo "- 无数据上传"
echo "- 隐私保护优先"
echo "- 离线可用"