#!/bin/bash
# 搜索脚本

WORKSPACE="/root/clawd"
QUERY="$1"

echo "🔍 搜索记忆: '$QUERY'"

# 尝试Git Notes搜索
echo ""
echo "📁 Git Notes搜索结果:"
python3 /root/clawd/skills/git-notes-memory/memory.py -p "$WORKSPACE" search "$QUERY" 2>/dev/null || echo "未找到Git Notes匹配项"

# 提示用户还可以使用百度Embedding搜索
echo ""
echo "🌐 百度Embedding语义搜索:"
echo "提示: 您可以使用百度Embedding进行语义搜索"
python3 -c "
import sys
sys.path.append('/root/clawd/skills/memory-baidu-embedding-db')
from memory_baidu_embedding_db import MemoryBaiduEmbeddingDB

try:
    db = MemoryBaiduEmbeddingDB()
    results = db.search_memories('$QUERY', limit=5)
    if results:
        print(f'找到 {len(results)} 条相关记忆:')
        for i, res in enumerate(results, 1):
            similarity = res.get('similarity', 0)
            content_preview = res['content'][:60] + '...' if len(res['content']) > 60 else res['content']
            print(f'  {i}. 相似度: {similarity:.3f} - {content_preview}')
    else:
        print('未找到语义匹配项')
except Exception as e:
    print(f'语义搜索出错: {str(e)}')
"