#!/bin/bash
# 记忆添加脚本

WORKSPACE="/root/clawd"
CONTENT="$1"

# 解析额外参数
TAGS=""
IMPORTANCE="n"

shift
while [[ $# -gt 0 ]]; do
    case $1 in
        --tags)
            TAGS="$2"
            shift 2
            ;;
        --importance|-i)
            IMPORTANCE="$2"
            # 转换为Git Notes接受的格式
            case "$IMPORTANCE" in
                "critical"|c) IMPORTANCE="c" ;;
                "high"|h) IMPORTANCE="h" ;;
                "normal"|n) IMPORTANCE="n" ;;
                "low"|l) IMPORTANCE="l" ;;
                *) IMPORTANCE="n" ;;  # 默认值
            esac
            shift 2
            ;;
        *)
            shift
            ;;
    esac
done

echo "🧠 添加记忆: $CONTENT"

# 使用Git Notes添加结构化记忆
if [ -n "$TAGS" ] && [ -n "$IMPORTANCE" ]; then
    RESULT=$(python3 /root/clawd/skills/git-notes-memory/memory.py -p "$WORKSPACE" remember "{\"content\": \"$CONTENT\"}" -t "$TAGS" -i "$IMPORTANCE" 2>&1)
else
    RESULT=$(python3 /root/clawd/skills/git-notes-memory/memory.py -p "$WORKSPACE" remember "{\"content\": \"$CONTENT\"}" 2>&1)
fi

if [ $? -eq 0 ]; then
    echo "✅ 记忆添加成功"
    if [ -n "$RESULT" ]; then
        echo "   ID: $RESULT"
    fi
else
    echo "❌ 记忆添加失败"
    echo "   错误: $RESULT"
    echo ""
    echo "💡 提示: 确保Git系统已正确初始化"
    echo "   运行: secure-memory fix git"
fi