#!/bin/bash
# 记忆系统启动检查脚本
# 检查环境变量和百度API连接

echo "🔍 记忆系统启动检查..."

# 检查必要环境变量
echo "  检查环境变量..."
if [ -z "$BAIDU_API_STRING" ]; then
    echo "  ❌ 错误: 缺少 BAIDU_API_STRING 环境变量"
    echo "  请设置: export BAIDU_API_STRING='your_bce_v3_api_string'"
    exit 1
else
    echo "  ✅ BAIDU_API_STRING 已设置"
fi

if [ -z "$BAIDU_SECRET_KEY" ]; then
    echo "  ❌ 错误: 缺少 BAIDU_SECRET_KEY 环境变量"
    echo "  请设置: export BAIDU_SECRET_KEY='your_secret_key'"
    exit 1
else
    echo "  ✅ BAIDU_SECRET_KEY 已设置"
fi

# 测试百度API连接
echo "  测试百度API连接..."
python3 -c "
import sys
import os
sys.path.append('/root/clawd/skills/baidu-vector-db/')
from baidu_embedding_bce_v3 import BaiduEmbeddingBCEV3

api_string = os.getenv('BAIDU_API_STRING')
secret_key = os.getenv('BAIDU_SECRET_KEY')

print('  正在测试百度Embedding API连接...')
try:
    client = BaiduEmbeddingBCEV3(api_string, secret_key)
    test_text = '系统健康检查'
    embedding = client.get_embedding_vector(test_text, model='embedding-v1')
    
    if embedding and len(embedding) > 0:
        print('  ✅ 百度API连接成功!')
        print(f'  🧠 向量维度: {len(embedding)}')
        print(f'  🧪 测试文本: \"{test_text}\"')
        sys.exit(0)
    else:
        print('  ❌ API返回空向量')
        sys.exit(1)
        
except Exception as e:
    print(f'  ❌ API连接测试失败: {str(e)}')
    sys.exit(1)
"

if [ $? -eq 0 ]; then
    echo "  ✅ 记忆系统环境检查通过"
    echo "  🧠 三重记忆系统准备就绪"
    echo "  - 语义搜索: 百度Embedding向量数据库"
    echo "  - 结构化记忆: Git Notes系统" 
    echo "  - 文件搜索: 本地文件系统"
    echo ""
    echo "  🚀 记忆系统已完全激活!"
else
    echo "  ❌ 记忆系统环境检查失败"
    echo "  请确保环境变量已正确设置并可以访问百度API"
    exit 1
fi