#!/bin/bash
# model_change_memory_loader.sh
# 模型切换时加载记忆系统的Hook脚本

echo "🔄 检测到模型切换事件，正在加载记忆系统..."

# 获取当前模型信息
CURRENT_MODEL="${NEW_MODEL:-unknown}"
PREVIOUS_MODEL="${OLD_MODEL:-unknown}"

echo "🔄 从模型 '$PREVIOUS_MODEL' 切换到 '$CURRENT_MODEL'"

# 设置环境变量以确保记忆系统正常运行
export BAIDU_EMBEDDING_ACTIVE=true
export EMBEDDING_CACHE_ENABLED=true
export VECTOR_SEARCH_OPTIMIZED=true
export PERFORMANCE_MODE=MAXIMUM

# 运行记忆系统的三步骤引导流程
echo "🧠 运行记忆系统三步骤引导流程..."

# 第一步：激活向量模型
echo "🔍 步骤1: 激活向量模型..."
if [ -n "$BAIDU_API_STRING" ] && [ -n "$BAIDU_SECRET_KEY" ]; then
    echo "   ✅ 百度API配置已激活"
else
    echo "   ⚠️  百度API配置缺失，跳过向量模型激活"
fi

# 第二步：自检配置
echo "🔧 步骤2: 自检配置..."
# 检查必要组件
COMPONENTS=("memory-baidu-embedding-db" "git-notes-memory" "triple-memory")
for component in "${COMPONENTS[@]}"; do
    if [ -d "/root/clawd/skills/$component" ]; then
        echo "   ✅ $component 已就绪"
    else
        echo "   ❌ $component 未找到"
    fi
done

# 第三步：激活所有模块
echo "⚡ 步骤3: 激活所有记忆模块..."
# 激活白名单技能
WHITELIST_SKILLS=("ai-sql" "x-api" "oauth-helper")
for skill in "${WHITELIST_SKILLS[@]}"; do
    if [ -d "/root/clawd/skills/$skill" ] && [ -f "/root/clawd/skills/$skill/WHITELISTED.md" ]; then
        echo "   ✅ $skill (白名单) 已激活"
    elif [ -d "/root/clawd/skills/$skill" ]; then
        echo "   ℹ️  $skill 已安装但未在白名单中"
    else
        echo "   ❌ $skill 未安装"
    fi
done

# 确保今日记忆文件存在
TODAY_MEMO="/root/clawd/memory/$(date +%Y-%m-%d).md"
mkdir -p /root/clawd/memory
if [ ! -f "$TODAY_MEMO" ]; then
    echo "# $(date +%Y-%m-%d) 记忆记录" > "$TODAY_MEMO"
    echo "" >> "$TODAY_MEMO"
    echo "## 活动摘要" >> "$TODAY_MEMO"
    echo "- 模型切换事件于 $(date) 激活记忆系统" >> "$TODAY_MEMO"
else
    echo "- 模型切换事件于 $(date) 激活记忆系统" >> "$TODAY_MEMO"
fi

# 运行引导脚本以确保系统处于最高效能状态
if [ -f "/root/clawd/memory_bootstrap.sh" ]; then
    echo "🚀 运行记忆系统引导脚本..."
    /root/clawd/memory_bootstrap.sh
fi

echo "🎯 模型切换事件处理完成，记忆系统已加载！"
echo "💡 新模型 '$CURRENT_MODEL' 现在已连接到记忆系统"