#!/bin/bash
# 记忆系统维护脚本
# memory_maintenance.sh

ACTION=${1:-"status"}

case "$ACTION" in
    "status")
        echo "📋 记忆系统状态检查..."
        /root/clawd/memory_performance_monitor.sh
        ;;
    "cleanup")
        echo "🧹 记忆系统清理..."
        # 清理临时文件
        find /root/clawd -name "*.tmp" -type f -delete 2>/dev/null || true
        find /root/clawd -name "*.temp" -type f -delete 2>/dev/null || true
        echo "✅ 临时文件清理完成"
        ;;
    "backup")
        echo "📦 记忆系统备份..."
        BACKUP_DIR="/root/clawd/backups/memory_$(date +%Y%m%d_%H%M%S)"
        mkdir -p "$BACKUP_DIR"
        
        # 备份记忆数据
        if [ -d "/root/clawd/memory" ]; then
            cp -r /root/clawd/memory "$BACKUP_DIR/"
        fi
        
        # 备份配置文件
        cp /root/clawd/MEMORY.md "$BACKUP_DIR/" 2>/dev/null || true
        cp /root/clawd/memory_system_config.json "$BACKUP_DIR/" 2>/dev/null || true
        
        echo "✅ 备份完成: $BACKUP_DIR"
        ;;
    "restore")
        echo "🔄 记忆系统恢复..."
        if [ -z "$2" ]; then
            echo "❌ 请指定备份目录路径"
            echo "用法: $0 restore <backup_directory>"
            exit 1
        fi
        
        BACKUP_PATH="$2"
        if [ -d "$BACKUP_PATH" ]; then
            if [ -d "$BACKUP_PATH/memory" ]; then
                cp -r "$BACKUP_PATH/memory" /root/clawd/
                echo "✅ 记忆数据恢复完成"
            fi
            
            if [ -f "$BACKUP_PATH/MEMORY.md" ]; then
                cp "$BACKUP_PATH/MEMORY.md" /root/clawd/
                echo "✅ 配置文件恢复完成"
            fi
            
            echo "✅ 从 $BACKUP_PATH 恢复完成"
        else
            echo "❌ 备份目录不存在: $BACKUP_PATH"
        fi
        ;;
    "optimize")
        echo "⚡ 记忆系统优化..."
        # 重新加载环境变量
        export BAIDU_EMBEDDING_ACTIVE=true
        export EMBEDDING_CACHE_ENABLED=true
        export VECTOR_SEARCH_OPTIMIZED=true
        export PERFORMANCE_MODE=MAXIMUM
        
        echo "✅ 环境变量已优化"
        ;;
    "refresh")
        echo "🔄 记忆系统刷新..."
        # 运行最高效能引导
        /root/clawd/memory_bootstrap.sh
        ;;
    *)
        echo "记忆系统维护工具"
        echo "用法: $0 {status|cleanup|backup|restore|optimize|refresh}"
        echo "  status   - 显示系统状态"
        echo "  cleanup  - 清理临时文件"
        echo "  backup   - 创建系统备份"
        echo "  restore  - 从备份恢复 (需要备份路径)"
        echo "  optimize - 优化系统配置"
        echo "  refresh  - 刷新系统状态"
        ;;
esac