---
name: secure-memory-stack
version: 1.0.0
description: 一个安全的本地化记忆系统，结合百度Embedding语义搜索、Git Notes结构化存储和文件系统，确保数据隐私和安全。
triggers:
  - "setup memory"
  - "configure memory"
  - "secure memory"
  - "local memory"
  - "privacy memory"
author: Clawdbot Team
---

# 安全记忆系统栈 (Secure Memory Stack)

一个安全的本地化记忆系统，结合百度Embedding语义搜索、Git Notes结构化存储和文件系统，确保数据隐私和安全。

## 功能特点

- ✅ **完全本地化** - 所有数据存储在本地设备
- ✅ **零数据上传** - 不向任何外部服务发送数据
- ✅ **语义搜索** - 基于百度Embedding的语义相似性搜索
- ✅ **结构化存储** - Git Notes提供结构化记忆管理
- ✅ **文件系统** - 传统文件存储，易管理
- ✅ **混合搜索** - 语义+关键词+标签搜索
- ✅ **隐私保护** - 完全数据主权

## 快速安装

```bash
clawdhub install secure-memory-stack
```

## 一键初始化

```bash
# 初始化安全记忆系统
bash /root/clawd/create/secure-memory-stack/scripts/setup.sh
```

## API配置引导

系统会自动检测并引导您配置必要的API密钥：

1. **百度Embedding API**（如果需要）
2. **其他可选服务**

## 使用指南

### 1. 系统初始化
```bash
# 首次设置
secure-memory setup
```

### 2. 检查系统状态
```bash
# 检查记忆系统状态
secure-memory status
```

### 3. 添加记忆
```bash
# 通过Git Notes添加结构化记忆
secure-memory remember "重要决策：使用本地化记忆系统" --tags decision,security --importance high

# 更新MEMORY.md添加长期记忆
secure-memory add-longterm "用户偏好：简洁高效沟通"
```

### 4. 搜索记忆
```bash
# 语义搜索
secure-memory search "安全配置"

# 结构化搜索
secure-memory find --tag security

# 文件搜索
secure-memory lookup "用户偏好"
```

### 5. 系统维护
```bash
# 检查系统健康状态
secure-memory health

# 查看统计信息
secure-memory stats
```

## 错误处理

### 常见错误及解决方案

**错误1**: "百度Embedding API连接失败"
- 解决方案: 检查百度API密钥配置
- 运行: `secure-memory configure baidu`

**错误2**: "Git Notes系统不可用"
- 解决方案: 确保Git已安装并正确配置
- 运行: `secure-memory fix git`

**错误3**: "文件权限错误"
- 解决方案: 检查工作区权限
- 运行: `secure-memory fix permissions`

**错误4**: "搜索无结果"
- 解决方案: 确认索引已更新
- 运行: `secure-memory refresh`

## 配置文件

系统将在以下位置创建配置文件：
- `/root/clawd/memory_config.json` - 主配置
- `/root/clawd/MEMORY.md` - 长期记忆
- `/root/clawd/SESSION-STATE.md` - 会话状态
- `/root/clawd/memory/` - 每日日志

## 目录结构

```
/root/clawd/
├── MEMORY.md              # 长期记忆
├── SESSION-STATE.md       # 活动工作记忆
├── memory/                # 每日日志
│   ├── YYYY-MM-DD.md      # 每日记忆日志
│   └── ...                # 历史日志
├── notes/                 # 知识组织
│   ├── projects/          # 项目
│   ├── areas/             # 领域
│   ├── resources/         # 资源
│   └── archive/           # 归档
└── skills/secure-memory-stack/
    ├── scripts/           # 管理脚本
    ├── configs/           # 配置模板
    └── docs/              # 文档
```

## 命令参考

### 主要命令
- `secure-memory setup` - 初始化系统
- `secure-memory status` - 检查系统状态
- `secure-memory search <query>` - 语义搜索
- `secure-memory remember <content>` - 添加记忆
- `secure-memory health` - 健康检查
- `secure-memory configure <service>` - 配置API
- `secure-memory fix <component>` - 修复组件

### 高级命令
- `secure-memory refresh` - 刷新索引
- `secure-memory backup` - 备份记忆
- `secure-memory restore` - 恢复记忆
- `secure-memory export` - 导出记忆
- `secure-memory stats` - 统计信息

## 安全特性

- **本地化存储**: 所有数据仅存储在本地
- **零上传**: 不向任何外部服务传输数据
- **访问控制**: 仅限本机访问
- **隐私保护**: 完全数据主权
- **加密支持**: 可选本地加密

## 故障排除

如果遇到问题，运行：
```bash
secure-memory diagnose
```

这将运行完整的系统诊断并提供解决方案。

## 更新系统

```bash
clawdhub update secure-memory-stack
```

## 卸载系统

```bash
secure-memory cleanup
```

注意：这将删除所有配置文件，但不会删除您的记忆文件。

## 贡献

欢迎提交Issue和Pull Request来改进此技能。