# 安全记忆系统栈 (Secure Memory Stack)

一个完全本地化的记忆系统，结合百度Embedding语义搜索、Git Notes结构化存储和文件系统，确保数据隐私和安全。

## 特性

- ✅ **完全本地化** - 所有数据存储在本地设备
- ✅ **零数据上传** - 不向任何外部服务发送数据
- ✅ **语义搜索** - 基于百度Embedding的语义相似性搜索
- ✅ **结构化存储** - Git Notes提供结构化记忆管理
- ✅ **文件系统** - 传统文件存储，易管理
- ✅ **混合搜索** - 语义+关键词+标签搜索
- ✅ **隐私保护** - 完全数据主权

## 安装

```bash
clawdhub install secure-memory-stack
```

## 快速开始

```bash
# 初始化系统
secure-memory setup

# 检查系统状态
secure-memory status

# 搜索记忆
secure-memory search "安全配置"

# 添加记忆
secure-memory remember "重要决策：使用本地化记忆系统" --tags decision,security --importance high

# 查看统计
secure-memory stats
```

## 命令参考

### 主要命令
- `secure-memory setup` - 初始化系统
- `secure-memory status` - 检查系统状态
- `secure-memory search <query>` - 语义搜索
- `secure-memory remember <content>` - 添加记忆
- `secure-memory health` - 健康检查
- `secure-memory configure <service>` - 配置API
- `secure-memory fix <component>` - 修复组件

### 高级命令
- `secure-memory stats` - 统计信息
- `secure-memory diagnose` - 系统诊断
- `secure-memory help` - 显示帮助

## 配置API

如果需要使用百度Embedding进行语义搜索：

```bash
secure-memory configure baidu
```

按照提示设置环境变量。

## 故障排除

如果遇到问题，运行：

```bash
secure-memory diagnose
```

这将运行完整的系统诊断并提供解决方案。

## 安全特性

- **本地化存储**: 所有数据仅存储在本地
- **零上传**: 不向任何外部服务传输数据
- **访问控制**: 仅限本机访问
- **隐私保护**: 完全数据主权
- **离线可用**: 无需网络连接

## 架构

系统采用三层架构：

1. **百度Embedding层** - 语义搜索（向量存储）
2. **Git Notes层** - 结构化查询（关系存储）
3. **文件系统层** - 原始存储（文档存储）

这种分层设计提供了最佳的搜索性能和数据管理灵活性。

## 贡献

欢迎提交Issue和Pull Request来改进此技能。