# 变更日志 (Changelog)

所有显著的变更都会在此文档中按版本记录。

## [1.0.0] - 2026-01-31

### 新增功能

- **三层记忆架构** - 实现了完整的三层存储系统
  - 百度Embedding语义搜索层
  - Git Notes结构化存储层  
  - 文件系统存储层
- **安全特性** - 完全本地化存储，零数据上传
- **CLI界面** - 完整的命令行工具集
  - `secure-memory setup` - 系统初始化
  - `secure-memory status` - 状态检查
  - `secure-memory search` - 语义搜索
  - `secure-memory remember` - 添加记忆
  - `secure-memory stats` - 统计信息
  - `secure-memory diagnose` - 系统诊断
- **标签系统** - 支持记忆标签分类
- **重要性分级** - Critical, High, Normal, Low 四级重要性
- **API配置** - 百度Embedding API集成向导
- **故障修复** - Git、权限等问题修复工具
- **数据隐私** - 本地存储，无网络传输

### 架构设计

- **模块化设计** - 可扩展的插件架构
- **向后兼容** - 保证未来版本兼容性
- **错误处理** - 完善的错误提示和解决建议
- **性能优化** - 快速搜索和响应时间

### 文档

- 完整的用户手册
- 开发者指南
- 升级和迁移指南
- API参考文档

### 内部变化

- 基于百度Embedding-V1的语义搜索实现
- Git Notes集成的结构化存储
- 多层搜索算法优化
- 安全配置验证机制

## 设计理念

### 隐私优先
- 数据永不离开用户设备
- 无任何形式的云端同步
- 完全本地化处理

### 易用性
- 简洁直观的CLI界面
- 智能默认配置
- 清晰的错误提示

### 可扩展性
- 模块化架构设计
- 插件化功能扩展
- 标准化的API接口

## 未来规划

- 图形用户界面 (GUI)
- 高级分析功能
- 团队协作模式
- 更多语义引擎支持
- 移动端适配

---
记录格式遵循 [Keep a Changelog](https://keepachangelog.com/en/1.0.0/) 标准。
版本号遵循 [Semantic Versioning](https://semver.org/spec/v2.0.0.html) 规范。