---
name: secucheck
description: Comprehensive security audit for OpenClaw. Scans 7 domains (runtime, channels, agents, cron, skills, sessions, network), supports 3 expertise levels, context-aware analysis, and visual dashboard. Read-only with localized reports.
tags: [security, audit, hardening, runtime, dashboard, prompt-injection]
---

# secucheck - OpenClaw Security Audit

Comprehensive security audit skill for OpenClaw deployments. Analyzes configuration, permissions, exposure risks, and runtime environment with context-aware recommendations.

---

## Summary

**secucheck** performs read-only security audits of your OpenClaw setup:

- **7 audit domains**: Runtime, Channels, Agents, Cron Jobs, Skills, Sessions, Network
- **3 expertise levels**: Beginner (analogies), Intermediate (technical), Expert (attack vectors)
- **Context-aware**: Considers VPN, single-user, self-hosted scenarios
- **Runtime checks**: Live system state (network exposure, containers, privileges)
- **Dashboard**: Visual HTML report with security score
- **Localized output**: Final report matches user's language

**Never modifies configuration automatically.** All fixes require explicit user confirmation.

---

## Quick Start

### Installation
```bash
clawhub install secucheck
```

### Usage
Ask your OpenClaw agent:
- "security audit"
- "secucheck"
- "run security check"

### Expertise Levels
When prompted, choose your level:
1. **Beginner** - Simple analogies, no jargon
2. **Intermediate** - Technical details, config examples
3. **Expert** - Attack vectors, edge cases, CVEs

All levels run the same checks—only explanation depth varies.

### Dashboard
```
"show dashboard" / "visual report"
```
Opens an HTML report in your browser.

---

## Example Output

```
🔒 Security Audit Results

🟡 Needs Attention

| Severity | Count |
|----------|-------|
| 🔴 Critical | 0 |
| 🟠 High | 0 |
| 🟡 Medium | 2 |
| 🟢 Low | 3 |

### 🟡 Agent "molty": exec + external content processing
...
```

---

## Features

- 🔍 **Comprehensive**: Channels, agents, cron, skills, sessions, network, runtime
- 👤 **3 Expertise Levels**: Beginner / Intermediate / Expert
- 🌏 **Localized**: Final report in user's language
- 🎯 **Attack Scenarios**: Real-world exploitation paths
- ⚡ **Runtime Checks**: VPN, containers, privileges, network exposure
- 🎨 **Dashboard**: Visual HTML report with security score

---

# Agent Instructions

*Everything below is for the agent executing this skill.*

---

## When to Use

Trigger this skill when:
- User requests security checkup/audit
- **Auto-trigger**: Installing skills, creating/modifying agents, adding/modifying cron jobs
- Periodic review (recommended: weekly)

## Expertise Levels

| Level | Identifier | Style |
|-------|------------|-------|
| Beginner | `1`, `beginner` | Analogies, simple explanations, no jargon |
| Intermediate | `2`, `intermediate` | Technical details, config examples |
| Expert | `3`, `expert` | Attack vectors, edge cases, CVE references |

## Execution Flow

### Step 1: Ask Level (before running anything)

Present options in user's language. Example (English):

```
What level of technical detail do you prefer?

1. 🌱 Beginner - I'll explain simply with analogies
2. 💻 Intermediate - Technical details and config examples
3. 🔐 Expert - Include attack vectors and edge cases

📌 All levels run the same checks—only explanation depth varies.
```

**STOP HERE. Wait for user response.**

### Step 2: Run Audit

```bash
bash ~/.openclaw/skills/secucheck/scripts/full_audit.sh
```

Returns JSON with findings categorized by severity.

### Step 3: Format Output

Parse JSON output and format based on user's expertise level.
**Final report must be in user's language.**

#### Report Structure (Organize by Category)

```
🔒 Security Audit Results

📊 Summary Table
| Severity | Count |
|----------|-------|
| 🔴 Critical | X |
| ...

⚡ Runtime
- [findings related to RUNTIME category]

🤖 Agents  
- [findings related to AGENT category]

📁 Workspace
- [findings related to WORKSPACE category]

🧩 Skills
- [findings related to SKILL category]

📢 Channels
- [findings related to CHANNEL category]

🌐 Network
- [findings related to NETWORK category]
```

Group findings by their `category` field, not just severity.
Within each category, show severity icon and explain.

### Step 4: Auto-Open Dashboard

After text report, automatically generate and serve dashboard:

```bash
bash ~/.openclaw/skills/secucheck/scripts/serve_dashboard.sh
```

The script returns JSON with `url` (LAN IP) and `local_url` (localhost).
**Use the `url` field** (not localhost) when telling the user — they may access from another device.

Example:
```
📊 대시보드도 열었어요: http://192.168.1.200:8766/secucheck-report.html
```

If running in environment where browser can be opened, use browser tool to open it.

## Cross-Platform Support

Scripts run on Linux, macOS, and WSL. Check the JSON output for platform info:

```json
{
  "os": "linux",
  "os_variant": "ubuntu",
  "in_wsl": false,
  "in_dsm": false,
  "failed_checks": ["external_ip"]
}
```

### Platform Detection

| Field | Values |
|-------|--------|
| `os` | `linux`, `macos`, `windows`, `unknown` |
| `os_variant` | `ubuntu`, `arch`, `dsm`, `wsl`, version string |
| `in_wsl` | `true` if Windows Subsystem for Linux |
| `in_dsm` | `true` if Synology DSM |

### Handling Failed Checks

If `failed_checks` array is non-empty, run fallback commands based on platform:

#### Network Info Fallbacks

| Platform | Command |
|----------|---------|
| Linux | `ip addr show` or `ifconfig` |
| macOS | `ifconfig` |
| WSL | `ip addr show` (or check Windows via `cmd.exe /c ipconfig`) |
| Windows | PowerShell: `Get-NetIPAddress` |
| DSM | `ifconfig` or `/sbin/ip addr` |

#### Gateway Binding Fallbacks

| Platform | Command |
|----------|---------|
| Linux | `ss -tlnp \| grep :18789` or `netstat -tlnp` |
| macOS | `lsof -iTCP:18789 -sTCP:LISTEN` |
| Windows | PowerShell: `Get-NetTCPConnection -LocalPort 18789` |

#### File Permissions Fallbacks

| Platform | Command |
|----------|---------|
| Linux/macOS | `ls -la ~/.openclaw` |
| Windows | PowerShell: `Get-Acl $env:USERPROFILE\.openclaw` |

### Windows Native Support

If `os` is `windows` and scripts fail completely:

1. Use PowerShell commands directly:
```powershell
# Network exposure
Get-NetTCPConnection -LocalPort 18789 -State Listen

# File permissions
Get-Acl "$env:USERPROFILE\.openclaw"

# Process info
Get-Process | Where-Object {$_.Name -like "*openclaw*"}
```

2. Report what you can check and note Windows-specific limitations.

### Minimal Environments (Docker, DSM)

Some environments lack tools. Check output and supplement:

| Missing Tool | Fallback |
|--------------|----------|
| `curl` | `wget -qO-` |
| `ss` | `netstat` |
| `ip` | `ifconfig` or `/sbin/ip` |
| `pgrep` | `ps aux \| grep` |

### Agent Decision Flow

```
1. Run full_audit.sh
2. Check "failed_checks" in output
3. For each failed check:
   a. Identify platform from os/os_variant
   b. Run platform-specific fallback command
   c. Incorporate results into report
4. Note any checks that couldn't complete
```

## Dashboard Generation

When user requests visual report:

```bash
bash ~/.openclaw/skills/secucheck/scripts/serve_dashboard.sh
```

Returns:
```json
{
  "status": "ok",
  "url": "http://localhost:8766/secucheck-report.html",
  "pid": 12345
}
```

Provide URL directly to user.

## Detailed Check References

Read these only when deep explanation needed:

| File | Domain |
|------|--------|
| `checks/runtime.md` | Live system state |
| `checks/channels.md` | Channel policies |
| `checks/agents.md` | Agent permissions |
| `checks/cron.md` | Scheduled jobs |
| `checks/skills.md` | Installed skills |
| `checks/sessions.md` | Session isolation |
| `checks/network.md` | Network configuration |

## Attack Scenario Templates

Use these for expert-level explanations:

| File | Scenario |
|------|----------|
| `scenarios/prompt-injection.md` | External content manipulation |
| `scenarios/session-leak.md` | Cross-session data exposure |
| `scenarios/privilege-escalation.md` | Tool permission abuse |
| `scenarios/credential-exposure.md` | Secret leakage |
| `scenarios/unauthorized-access.md` | Access control bypass |

## Risk Levels

```
🔴 Critical - Immediate action required. Active exploitation possible.
🟠 High     - Significant risk. Should fix soon.
🟡 Medium   - Notable concern. Plan to address.
🟢 Low      - Minor issue or best practice recommendation.
⚪ Info     - Not a risk, but worth noting.
```

## Risk Matrix

```
                Tool Permissions
              Minimal       Full
         ┌──────────┬──────────┐
Exposure │   🟢     │   🟡     │
  Low    │  Safe    │  Caution │
         ├──────────┼──────────┤
         │   🟡     │   🔴     │
  High   │ Caution  │ Critical │
         └──────────┴──────────┘

Exposure = Who can talk to the bot (DM policy, group access, public channels)
Tool Permissions = What the bot can do (exec, file access, messaging, browser)
```

## Context-Aware Exceptions

Don't just pattern match. Consider context:

| Context | Adjustment |
|---------|------------|
| Private channel, 2-3 trusted members | Lower risk even with exec |
| VPN/Tailscale only access | Network exposure less critical |
| Self-hosted, single user | Session isolation less important |
| Containerized environment | Privilege escalation less severe |

Always ask about environment if unclear.

## Applying Fixes

**CRITICAL RULES:**

1. **Never auto-apply fixes.** Always show suggestions first.
2. **Warn about functional impact.** If a fix might break something, say so.
3. **Get explicit user confirmation** before any config changes.

Example flow:
```
Agent: "Changing this setting will disable exec in #dev channel.
        If you're using code execution there, it will stop working.
        Apply this fix?"
User: "yes"
Agent: [apply fix via gateway config.patch]
```

## Language Rules

- **Internal processing**: Always English
- **Thinking/reasoning**: Always English
- **Final user-facing report**: Match user's language
- **Technical terms**: Keep in English (exec, cron, gateway, etc.)

## Auto-Review Triggers

Invoke automatically when:

1. **Skill installation**: `clawhub install <skill>` or manual addition
2. **Agent creation/modification**: New agent or tool changes
3. **Cron job creation/modification**: New or modified scheduled tasks

For auto-reviews, focus only on changed component unless full audit requested.

## Quick Commands

| User Request | Action |
|--------------|--------|
| "check channels only" | Run channels.md check |
| "audit cron jobs" | Run cron.md check |
| "full audit" | All checks |
| "more detail" | Re-run with verbose output |

## Trust Hierarchy

Apply appropriate trust levels:

| Level | Entity | Trust Model |
|-------|--------|-------------|
| 1 | Owner | Full trust — has all access |
| 2 | AI Agent | Trust but verify — sandboxed, logged |
| 3 | Allowlists | Limited trust — specified users only |
| 4 | Strangers | No trust — blocked by default |

## Incident Response Reference

If compromise suspected:

### Containment
1. Stop gateway process
2. Set gateway.bind to loopback (127.0.0.1)
3. Disable risky DM/group policies

### Rotation
1. Regenerate gateway auth token
2. Rotate browser control tokens
3. Revoke and rotate API keys

### Review
1. Check gateway logs and session transcripts
2. Review recent config changes
3. Re-run full security audit

## Files Reference

```
~/.openclaw/skills/secucheck/
├── SKILL.md              # This file
├── skill.json            # Package metadata
├── README.md             # User documentation
├── scripts/
│   ├── full_audit.sh     # Complete audit (JSON output)
│   ├── runtime_check.sh  # Live system checks
│   ├── gather_config.sh  # Config extraction (redacted)
│   ├── gather_skills.sh  # Skill security scan
│   ├── gather_agents.sh  # Agent configurations
│   ├── serve_dashboard.sh # Generate + serve HTML report
│   └── generate_dashboard.sh
├── dashboard/
│   └── template.html     # Dashboard template
├── checks/
│   ├── runtime.md        # Runtime interpretation
│   ├── channels.md       # Channel policy checks
│   ├── agents.md         # Agent permission checks
│   ├── cron.md           # Cron job checks
│   ├── skills.md         # Skill safety checks
│   ├── sessions.md       # Session isolation
│   └── network.md        # Network exposure
├── scenarios/
│   ├── prompt-injection.md
│   ├── session-leak.md
│   ├── privilege-escalation.md
│   ├── credential-exposure.md
│   └── unauthorized-access.md
└── templates/
    ├── report.md         # Full report template
    ├── finding.md        # Single finding template
    └── summary.md        # Quick summary template
```

## Security Assessment Questions

When auditing, consider:

1. **Exposure**: What network interfaces can reach this agent?
2. **Authentication**: What verification does each access point require?
3. **Isolation**: What boundaries exist between agent and host?
4. **Trust**: What content sources are considered "trusted"?
5. **Auditability**: What evidence exists of agent's actions?
6. **Least Privilege**: Does agent have only necessary permissions?

---

**Remember:** This skill exists to make OpenClaw self-aware of its security posture. Use regularly, extend as needed, never skip the audit.
