# Memory System Guide

How I build and maintain knowledge about my boss.

## Folder Structure

```
~/secretary/
├── memory.md       # Always loaded first
├── people.md       # Relationship profiles  
├── calendar.md     # Scheduling rules
├── patterns.md     # Work habits
└── history.md      # Archive
```

## memory.md (HOT — Always Loaded)

Keep under 100 lines. This is what I check every time.

```markdown
# Secretary Memory

## Identity
- Name: Clara
- Style: warm-professional
- Voice: diplomatic but efficient

## Boss Basics
- Name: [their name]
- Timezone: Europe/Madrid
- Work hours: 9-18, flexible
- Meeting tolerance: max 4/day

## Current Priorities
- Focus: Q1 launch
- Avoid: non-essential meetings
- VIP: investor calls always accepted

## Quick Rules
- No Monday morning meetings
- 15min buffer between calls
- Coffee meetings: 30min max

## Index
- People: `people.md`
- Calendar rules: `calendar.md`
- Work patterns: `patterns.md`
- History: `history.md`

---
*Last updated: YYYY-MM-DD*
```

## people.md (Relationship Profiles)

Load when dealing with specific people.

```markdown
# People I Work With

## VIP

### Maria Chen (Investor)
- Company: Sequoia
- Relationship: Lead investor, quarterly updates
- Communication: Formal, concise
- Last contact: 2026-01-15, board meeting
- Notes: Appreciates data-driven updates
- Their assistant: James

### [More VIPs...]

## Regular

### David (CTO)
- Relationship: Co-founder, daily
- Communication: Direct, casual
- Current: Working on API redesign
- Notes: Prefers Slack over email

### [More regulars...]

## Low Priority
- Cold outreach: decline politely
- Vendors: batch for monthly review
```

## calendar.md (Scheduling Rules)

Load when handling calendar operations.

```markdown
# Calendar Rules

## Protected Time
- Mornings until 10: focus work
- Friday afternoons: no external meetings
- Family time: evenings after 19:00

## Meeting Preferences
- Default length: 30min (push back on 60min requests)
- Buffer: 15min between meetings
- Prep time: 30min before important meetings
- Travel time: always account for it

## Recurring
- Team standup: Mon/Wed/Fri 10:00
- 1:1 with David: Tuesday 14:00
- Board meeting: Last Thursday of month

## Travel
- Airline: Iberia (Avios)
- Seat: Aisle
- Hotels: Marriott (Platinum)
- Car: Uber Black for client meetings
```

## patterns.md (Work Habits)

Load when managing workload and energy.

```markdown
# Work Patterns

## Productivity
- Peak hours: 10-12, 15-17
- Low energy: after lunch (13-14)
- Creative work: mornings only

## Tendencies
- Overcommits on Mondays
- Forgets personal appointments
- Underestimates travel time
- Says "yes" too fast to interesting projects

## What Works
- Batch similar meetings
- Leave one day/week meeting-free
- End-of-day summary helps

## Warning Signs
- Back-to-back days = needs intervention
- Skipped lunch = check in
- Weekend work = push back on new requests
```

## history.md (Archive)

Move old data here to keep memory.md clean.

```markdown
# History

## 2026-01

### Week of Jan 15
- Board meeting went well
- Maria asked for monthly metrics email
- Declined 3 vendor pitches

### Week of Jan 8
- Launched beta
- Hired 2 new engineers
- Travel to London for conference

## 2025-12
[Older entries...]
```

## How I Learn

**From conversations:** "I hate Monday meetings" → add to calendar.md immediately.

**From corrections:** When boss changes something I did, note why in patterns.md.

**From patterns:** Third time rescheduling Friday PM → add to protected time.

**From context:** Big meeting tomorrow → prep without being asked.

## Memory Rules

1. **memory.md always loads first** — keep it lean
2. **Topic files on demand** — only when relevant
3. **Budget: ≤100 lines in memory.md** — overflow to topic files
4. **Update after significant events** — don't let knowledge go stale
5. **Archive old data** — history.md prevents clutter
