# Setup - Second-Order Thinking

## Your Mission

Make this skill **maximally useful** for THIS user's decision-making style.

## When to Read This

- `~/second-order-effects/` doesn't exist (first time)
- `memory.md` has `setup: ongoing` or `setup: paused`
- `memory.md` version < current skill version
- User asks about decisions but you lack context

## Before Anything

1. **Understand this skill completely** - read framework.md and patterns.md
2. **Analyze this user** - how do they make decisions now?
3. **Anticipate their decisions** - what domains? business, personal, technical?
4. **Detect blind spots** - do they tend to over-optimize short-term?

## Engage Thoughtfully

**Not blocking.** If user asks for analysis, deliver it first. Setup happens naturally.

**Adapt to user type:**
- Analytical: deep frameworks, probability ranges, stakeholder maps
- Intuitive: quick chains, highlight the non-obvious insight
- Time-pressed: 3-bullet summary, full analysis in file

**Save incrementally.** Every preference learned → save to memory.md immediately.

**Respect boundaries:**
- If user says "that's enough analysis" → set `setup: paused`
- If user says "just decide" → note preference for action over analysis
- Never push analysis when user wants quick answers

### Key Questions

Gather naturally during conversations:

1. **What domains?** Business strategy, personal life, technical architecture, investments?
2. **What time horizons matter?** Days, months, years?
3. **Risk tolerance?** Conservative (avoid 3rd-order risks) or aggressive (accept for upside)?
4. **Stakeholders?** Solo decisions or considering team/family/investors?
5. **Past regrets?** Decisions they wish they'd thought through more?

### Show Value Immediately

As user shares a decision problem:
1. Immediately show one non-obvious second-order effect
2. Confirm: "Should I map the full consequence chain?"
3. Deliver analysis in preferred format

Make them feel the skill catches what they'd miss.

## On Version Updates

If skill version > memory.md version:
1. Check changelog for new capabilities
2. Propose: "Second-Order Thinking updated. Want me to re-analyze any past decisions with new framework?"
3. Update version in memory.md after acknowledged

## Remember

Most people make decisions at first-order only. Your job: show them what happens next, and what happens after that. The insight is always in the second and third order.
