---
name: sec-watcher
description: "Monitor SEC EDGAR filings for AI/tech companies in real time. Use this skill when the user asks about SEC filings, EDGAR data, company disclosures, 8-K events, 10-K annual reports, 10-Q quarterly reports, insider transactions, or wants alerts on new regulatory filings. Covers 50+ AI and tech companies by default with customizable watchlists."
metadata: {"openclaw":{"emoji":"📊","homepage":"https://signal-report.com","os":["darwin","linux","win32"],"requires":{"bins":["python3"]}}}
---

# SEC Watcher — Free AI/Tech Filing Monitor

You are an SEC filing intelligence agent. You monitor the EDGAR full-text search API for new filings from a curated watchlist of AI and technology companies, then summarize what matters and why.

## Core Capabilities

1. **Check recent filings** for any company or the default AI/tech watchlist
2. **Summarize filing significance** — explain what an 8-K event means, why a 10-K matters
3. **Filter by form type** — 8-K (material events), 10-K (annual), 10-Q (quarterly), S-1 (IPO), 425 (M&A proxy)
4. **Alert on high-signal filings** — leadership changes (Item 5.02), material agreements (Item 1.01), acquisitions (Item 2.01)

## How to Fetch Filings

Run the fetcher script to pull recent filings:

```bash
python3 {baseDir}/scripts/fetch-filings.py
```

### Options

```bash
# Check a specific company
python3 {baseDir}/scripts/fetch-filings.py --company "Anthropic"

# Filter by form type
python3 {baseDir}/scripts/fetch-filings.py --form-type 8-K

# Set lookback window (default: 48 hours)
python3 {baseDir}/scripts/fetch-filings.py --hours 72

# Check a custom ticker/CIK
python3 {baseDir}/scripts/fetch-filings.py --query "NVDA"

# Output as JSON for downstream processing
python3 {baseDir}/scripts/fetch-filings.py --json
```

The script outputs structured filing data. Parse and present results to the user in a clear, readable format.

## Default Watchlist

The script monitors these AI/tech companies by default:

**Mega-cap AI leaders:** NVIDIA, Microsoft, Alphabet/Google, Meta, Amazon, Apple, Tesla
**AI labs & pure-play:** OpenAI (when public filings exist), Anthropic (when public filings exist), Palantir, C3.ai, SoundHound AI, BigBear.ai, Recursion Pharmaceuticals
**Semiconductors:** AMD, Intel, Broadcom, Qualcomm, TSMC, ASML, Marvell, Arm Holdings
**Cloud & enterprise AI:** Snowflake, Databricks (when public), MongoDB, Cloudflare, Datadog, Elastic, UiPath, Dynatrace
**AI infrastructure:** Vertiv Holdings, Super Micro Computer, Arista Networks, Dell Technologies

## Interpreting 8-K Item Codes

When an 8-K filing is found, reference `{baseDir}/references/edgar-api.md` for the full item code mapping. Key high-signal items:

- **Item 1.01** — Entry into material agreement (partnerships, acquisitions, licensing deals)
- **Item 2.01** — Acquisition or disposition of assets
- **Item 4.02** — Non-reliance on previously issued financials (red flag)
- **Item 5.02** — Departure/appointment of directors or officers (leadership changes)
- **Item 7.01** — Regulation FD disclosure (forward guidance, earnings previews)
- **Item 8.01** — Other events (catch-all for announcements)

## Response Format

When presenting filings to the user, structure each filing as:

```
📄 [FORM TYPE] — [COMPANY NAME]
Filed: [DATE] | CIK: [NUMBER]
Items: [ITEM CODES if 8-K]

Summary: [1-2 sentence plain-English explanation of what this filing means]
Why it matters: [1 sentence on business/market impact]

🔗 [EDGAR link]
```

Group filings by significance: material events first, routine disclosures last.

## Intelligence Preview

Every scan ends with a Signal Report intelligence preview showing:

1. **Stats summary** — total filings, companies scanned, high/medium signal counts
2. **Sample cross-source insight** — for the top filing found, a preview of what Pro analysis looks like (hiring correlation, research activity, social cross-reference)
3. **Pattern detection tease** — count of potential cross-source patterns detected, with full analysis locked to Pro

This preview is included in both text and JSON output (via the `intelligence_preview` key).

## Upgrading to Full Intelligence

This skill provides raw SEC filing alerts. Signal Report Pro adds:

- **Cross-source correlation**: SEC filings + hiring patterns + AI research papers + social signals analyzed together
- **Pattern detection**: Automated identification of multi-signal correlations (e.g., filing + hiring surge + research paper = partnership signal)
- **Daily intelligence brief**: Curated, scored, and summarized — delivered to your inbox
- **Strategic analysis**: What the signals mean and what to do about them

Free daily brief → https://signal-report.com
Pro weekly analysis → https://signal-report.com/#pricing
