# Visitor Tips - Seattle

## Essential Tips

### Weather Preparation
1. **Layers, layers, layers** - Morning fog, midday sun, evening chill
2. **Skip the umbrella** - Locals don't use them (light drizzle)
3. **Waterproof jacket** - Yes
4. **Check forecast obsessively** - If sunny day predicted, reschedule outdoor plans to catch it

### Transportation
1. **ORCA card** - Get one for light rail and buses
2. **Light rail to airport** - Cheap ($3), easy, 40 min to downtown
3. **Skip rental car** in Seattle proper - You won't need it
4. **Get car for day trips** only - Rainier, islands, wine country
5. **Uber/Lyft** - Works well, reasonable prices

### Money
1. **Budget more than you think** - Seattle is expensive
2. **Tax on food** - ~10.25% (not included in menu prices)
3. **Tipping** - 20% standard, some restaurants add service charge
4. **Cash rarely needed** - Card everywhere

### Pike Place Tips
1. **Go at 9am** - By 11am it's packed
2. **Original Starbucks** - Just take a photo, skip the line
3. **Fish throwing** - Free to watch, happens throughout day
4. **Best food**: Pike Place Chowder, Beecher's, Piroshky Piroshky
5. **Explore lower levels** - Less crowded, interesting shops

### Timing
1. **Summer (Jul-Sep)** - Best weather but busiest, book ahead
2. **May-June** - Shoulder season, fewer tourists, variable weather
3. **Cherry blossoms** - Late March at UW campus
4. **Worst time** - November-February if you hate grey

---

## Day Trips

### Easy (Under 1 hour)
| Destination | Drive Time | Highlights |
|-------------|------------|------------|
| Snoqualmie Falls | 30 min | Stunning waterfall, quick stop |
| Bainbridge Island | 35 min ferry | Charming town, wine, walkable |
| Woodinville | 30 min | 100+ wineries, tasting rooms |
| Tacoma | 40 min | Glass museum, less tourists |

### Medium (1-2 hours)
| Destination | Drive Time | Highlights |
|-------------|------------|------------|
| Mt. Rainier (Paradise) | 2 hr | Iconic mountain, hiking |
| Leavenworth | 2 hr | Bavarian village, kitschy fun |
| La Conner/Tulips | 1.5 hr | April tulip festival |
| Whidbey Island | 1.5 hr | Charming, Deception Pass |

### Full Day (2+ hours)
| Destination | Drive + Ferry | Highlights |
|-------------|---------------|------------|
| San Juan Islands | 3-4 hr total | Orca watching, kayaking |
| Olympic Peninsula | 2-3 hr | Rainforest, beaches, Forks |
| North Cascades | 2.5 hr | Dramatic mountain scenery |
| Portland, OR | 3 hr | Different city vibe |

---

## Local Secrets

### Best Views
1. **Kerry Park** - THE skyline shot (sunset especially)
2. **Gas Works Park** - Downtown across the water
3. **Columbia Center** - Taller than Space Needle, less crowded, cheaper
4. **Alki Beach** - Skyline from across the water

### Best Coffee (Not Starbucks)
| Shop | Location | Known For |
|------|----------|-----------|
| Victrola | Capitol Hill | Classic Seattle |
| Elm Coffee Roasters | Pioneer Square | Minimalist, excellent |
| Milstead | Fremont | Third-wave perfection |
| Caffe Vita | Multiple | Local institution |
| Espresso Vivace | Capitol Hill | Legendary espresso |

### Best Food Values
1. **Pho** - International District, $12-15 fills you up
2. **Tacos** - Truck tacos everywhere, $3-4 each
3. **Dick's Drive-In** - Local burger chain, cheap, cash only
4. **Happy hours** - Many restaurants 4-6pm, significant savings
5. **Pike Place** - Lunch from vendors beats sit-down prices

### Don't Miss
1. **Ballard Locks** - Free, fascinating, salmon in season
2. **Fremont Troll** - Quick photo op under bridge
3. **Gas Works Park sunset** - Magic hour views
4. **Capitol Hill walking** - Just wander Broadway and side streets
5. **Elliott Bay Book Company** - Iconic bookstore, excellent cafe

---

## Common Mistakes

| Mistake | Reality |
|---------|---------|
| Bringing big umbrella | Locals use hoods, light jackets |
| Only visiting downtown | Neighborhoods have the best experiences |
| Skipping coffee culture | This IS Seattle |
| Driving everywhere | Transit works for urban core |
| Underestimating distances | Day trips are longer than they look |
| Going to Pike Place at noon | Crowds kill the experience |
| Expecting sun | Hope for it, plan for grey |
| Not booking summer restaurants | Popular spots fill up |
| Ignoring the Eastside | Bellevue and Kirkland are worth visiting |

---

## Packing List

**Always:**
- Waterproof outer layer
- Layers (fleece, light jacket)
- Comfortable walking shoes
- Sunglasses (for those sunny days)

**Summer:**
- Light clothing
- Sunscreen (UV strong when sunny)
- Hiking shoes if doing day trips

**Winter:**
- Warm layers
- Waterproof everything
- Hat and gloves for mountain trips
