# Transportation - Seattle

## Overview

Seattle is **improving but still car-helpful**. Unlike NYC, you can't fully rely on transit for everything. But it's much better than LA.

| Mode | Verdict |
|------|---------|
| Light Rail | Excellent and expanding |
| Buses | Good coverage, can be slow |
| Car | Needed for suburbs, day trips |
| Bike | Growing, hilly but e-bikes help |
| Walk | Great in urban neighborhoods |

---

## Light Rail (Link)

### Current System (2026)
- **1 Line:** Northgate to Angle Lake (Airport)
- **2 Line:** Opening to Eastside (Bellevue, Redmond)

### Key Stations
| Station | Near |
|---------|------|
| Westlake | Downtown, Pike Place |
| Capitol Hill | Nightlife, dining |
| UW | University of Washington |
| Northgate | North Seattle, mall |
| SeaTac | Airport |
| Beacon Hill | South Seattle |
| Columbia City | Diverse dining |

### Cost
- **Single ride:** $2.25-3.50 (distance-based)
- **Monthly pass:** $99
- **Airport trip:** $3.00 from downtown

### Tips
- ORCA card required (or tap credit card)
- Runs 5am-1am weekdays, later weekends
- Every 6-10 minutes at peak
- Clean and safe

---

## Buses

### Metro System
- Extensive coverage
- Some routes excellent, some slow
- Real-time tracking via apps

### Best Routes
| Route | Connects |
|-------|----------|
| Rapid Ride E | Downtown to Aurora |
| Rapid Ride D | Downtown to Ballard |
| Rapid Ride C | Downtown to West Seattle |
| 44 | Ballard to UW |
| 48 | Rainier Valley to UW |

### Apps
- **OneBusAway** — Real-time arrivals
- **Transit App** — Multi-modal planning
- **Google Maps** — Trip planning

### Tips
- ORCA card for cheaper fares
- Transfers free within 2 hours
- Express routes much faster
- Downtown can be confusing (multiple stops)

---

## ORCA Card

### What It Is
Regional transit card for all systems:
- Link Light Rail
- Metro buses
- Sound Transit
- Seattle Streetcar
- King County Water Taxi
- Ferries (some)

### Cost
- Card: $3 (reusable)
- Load value or monthly pass
- Tap credit card works too now

### Where to Get
- Light rail stations
- Metro offices
- Some retailers
- Online (mailed)

---

## Driving

### When You Need a Car
- Living in suburbs
- Day trips (mountains, wine country)
- Eastside commute
- Kids/family logistics
- Late night activities

### When You Don't
- Living in Capitol Hill
- Working downtown/SLU
- Light rail commute works
- Fine with occasional Uber

### Traffic Reality
| Route | Rush Hour |
|-------|-----------|
| I-5 (north-south) | Brutal |
| 520 Bridge | 30-60+ min |
| I-90 Bridge | 30-50 min |
| Aurora (99) | Slow |
| I-405 (Eastside) | Very bad |

### Rush Hours
- **Morning:** 7-9am
- **Evening:** 4-7pm
- **Worst day:** Friday afternoon

### Parking

| Location | Monthly Cost |
|----------|--------------|
| Downtown | $200-400 |
| Capitol Hill | $150-250 |
| Neighborhoods | $0-150 |
| Street parking | Free in some areas |

**Tips:**
- Many buildings include 1 spot
- Street parking competitive in popular areas
- SpotHero app for daily parking

---

## Ride-Hailing

### Apps
- **Uber** — Most common
- **Lyft** — Good alternative
- **Via** — Shared rides (cheaper)

### Cost
- Downtown to Capitol Hill: $8-12
- Downtown to Ballard: $15-25
- Downtown to Airport: $35-50

### Tips
- Surge pricing on rainy days
- Events cause major surges
- Schedule airport rides ahead
- Via is cheapest for short trips

---

## Biking

### Reality
- Growing infrastructure
- Hilly (e-bikes very popular)
- Weather limits (rain, dark winters)
- Theft is a problem

### Infrastructure
- Burke-Gilman Trail (north Seattle)
- Ship Canal Trail
- Growing protected bike lanes
- Some neighborhoods very bikeable

### Best Neighborhoods for Biking
| Area | Bike-Friendly |
|------|---------------|
| Fremont | Excellent |
| Ballard | Good |
| U-District | Good (flat to campus) |
| Capitol Hill | Possible but hilly |
| Downtown | Improving |

### Bike Share
- **Lime bikes** — Dockless, everywhere
- **Jump bikes** — E-bikes
- **Cost:** $1 unlock + $0.15-0.39/min

### Tips
- E-bike highly recommended (hills)
- Good rain gear essential
- Lights required (law and safety)
- Lock WELL (theft common)

---

## Water Transportation

### Ferries (Washington State Ferries)
| Route | Time | Cost |
|-------|------|------|
| Seattle to Bainbridge | 35 min | $9.25 walk-on |
| Seattle to Bremerton | 60 min | $9.25 walk-on |
| Edmonds to Kingston | 30 min | $9.25 walk-on |
| Mukilteo to Clinton | 20 min | $6.10 walk-on |

**Car ferry** costs more and requires wait time.

### Water Taxi
- West Seattle to downtown: 15 min, ~$5
- Connects to bus routes

---

## Airport (SeaTac)

### Getting There
| Method | Time | Cost |
|--------|------|------|
| Light Rail | 40 min | $3.00 |
| Uber/Lyft | 25-45 min | $35-50 |
| Taxi | 25-45 min | $45-55 |
| Shuttle | 45-60 min | $20-25 |

**Light rail is best** unless heavy luggage or odd hours.

### Tips
- Light rail runs 5am-1am
- International = longer walk in terminal
- TSA PreCheck saves time
- Airport is south of city

---

## Commute Recommendations

| Live | Work | Best Commute |
|------|------|--------------|
| Capitol Hill | Amazon (SLU) | Walk (15-20 min) |
| Capitol Hill | Downtown | Walk or light rail |
| Ballard | Downtown | Bus (25-40 min) |
| Bellevue | Microsoft | Drive (15 min) |
| Seattle | Microsoft | Light rail + shuttle or drive |
| Beacon Hill | Downtown | Light rail (10 min) |
| U-District | Downtown | Light rail (15 min) |

**Golden rule:** Live on same side of lake as work.
