# Tech Industry - Seattle

## Overview

Seattle metro is **one of the top 3 tech hubs in the US** (with SF and NYC). Two trillion-dollar companies are headquartered here: Amazon and Microsoft.

### Why Seattle for Tech

| Factor | Details |
|--------|---------|
| No state income tax | Save 10-13% vs California |
| Major HQs | Amazon, Microsoft |
| Talent pool | Deep and experienced |
| Cost of living | High but less than SF |
| Quality of life | Nature access, livable |
| Remote work | Many hybrid/remote options |

---

## Major Employers

### Amazon
- **HQ:** South Lake Union (Seattle)
- **Employees:** 50,000+ in Seattle metro
- **Focus:** Everything (retail, AWS, Alexa, etc.)
- **Culture:** Fast-paced, metrics-driven
- **Notable:** Return-to-office push (3 days minimum)

### Microsoft
- **HQ:** Redmond (Eastside)
- **Employees:** 50,000+ in Puget Sound
- **Focus:** Cloud (Azure), Office, Windows, Gaming
- **Culture:** More work-life balance than Amazon
- **Notable:** Hybrid work common

### Other Major Tech

| Company | Location | Focus |
|---------|----------|-------|
| Meta | Bellevue | Reality Labs, core apps |
| Google | Kirkland, Seattle | Cloud, ads, various |
| Apple | Seattle | Growing presence |
| Salesforce | Bellevue | After Tableau acquisition |
| Oracle | Seattle | Cloud |
| Snowflake | Bellevue | Data cloud |
| Stripe | Seattle | Payments |

### Startups
- Significant startup scene
- Many Amazon/Microsoft spinouts
- AI and cloud infrastructure popular
- See `startup.md` for details

---

## Compensation

### Total Compensation (Salary + Stock + Bonus)

| Level | Amazon | Microsoft | Meta | Google |
|-------|--------|-----------|------|--------|
| L4 (entry) | $180-220K | $160-190K | $180-230K | $180-220K |
| L5 (mid) | $280-350K | $220-280K | $300-380K | $280-350K |
| L6 (senior) | $400-500K | $350-450K | $450-550K | $400-500K |
| L7 (staff) | $550-700K | $500-650K | $600-800K | $600-750K |
| L8+ | $800K+ | $700K+ | $900K+ | $800K+ |

**Notes:**
- Ranges vary by team and negotiation
- Stock refreshers vary significantly
- Amazon has lower base, more stock
- Microsoft has more consistent bonuses

### By Company Culture

| Company | Base | Stock | Bonus | Style |
|---------|------|-------|-------|-------|
| Amazon | Lower | High (4-year vest back-loaded) | Moderate | Total comp focused |
| Microsoft | Moderate | Good (4-year vest) | Strong | Balanced |
| Meta | High | Very high | Good | Total comp focused |
| Google | High | High | Good | Balanced |

---

## Engineering Culture

### Amazon
- **Principles:** 16 Leadership Principles (memorize them)
- **Work style:** High ownership, high pressure
- **Reviews:** Stack ranking historically, modified now
- **RTO:** 3 days in office (2024+)
- **Tip:** "Bias for action" and "dive deep" come up constantly

### Microsoft
- **Culture:** Collaborative, growth mindset (Nadella era)
- **Work style:** More sustainable than Amazon
- **Reviews:** "Model, coach, care" framework
- **RTO:** Hybrid, flexible by team
- **Tip:** Good WLB compared to other Big Tech

### Meta
- **Culture:** "Move fast"
- **Work style:** High impact expected
- **Reviews:** Performance-focused
- **RTO:** Hybrid options
- **Tip:** Seattle office is Reality Labs heavy

### Google
- **Culture:** Engineering-driven
- **Work style:** More relaxed historically
- **Reviews:** Strong performer expectations
- **RTO:** Hybrid, 3 days typical
- **Tip:** Kirkland office is well-established

---

## Where to Live by Employer

### Amazon (South Lake Union)
| Best Areas | Commute |
|------------|---------|
| Capitol Hill | 15 min walk |
| South Lake Union | 5 min walk |
| Ballard | 20 min bus |
| Fremont | 15 min bus |
| Beacon Hill | 15 min light rail |

### Microsoft (Redmond)
| Best Areas | Commute |
|------------|---------|
| Redmond | 5-15 min drive |
| Bellevue | 15-25 min drive |
| Kirkland | 15-20 min drive |
| Seattle | 30-60 min (don't) |

**Rule:** Live on same side of lake as office.

---

## Interview Prep

### Amazon
- Leadership Principles (know all 16)
- STAR method for behavioral
- System design
- Coding (LeetCode medium)
- Bar raiser round

### Microsoft
- More traditional tech interview
- Coding (LeetCode medium)
- System design (senior+)
- Behavioral less intense than Amazon
- Team matching important

### Meta/Google
- Heavy on coding (LeetCode hard)
- System design (senior+)
- Behavioral varies
- Multiple rounds

### Resources
- LeetCode Premium (patterns)
- System Design Interview books
- Blind app (compensation data)
- Interview prep communities

---

## Networking

### Tech Meetups
- Seattle Tech Meetup
- AWS User Groups
- Various language/framework meetups
- Startup events

### Online
- Blind (anonymous, compensation focus)
- LinkedIn (mandatory)
- Seattle Tech Slack/Discord groups

### Conferences
- Re:Invent (AWS, Vegas)
- Microsoft Build
- Various smaller events

---

## Career Growth

### Paths
1. **Stay at one company:** Climb levels
2. **Company hop:** Faster compensation growth
3. **Startup:** Risk for potential upside
4. **Management:** IC to manager track
5. **Specialist:** Deep expertise

### Typical Timeline
| Years Experience | Level | Comp Range |
|------------------|-------|------------|
| 0-2 | L4 | $160-220K |
| 2-5 | L5 | $250-350K |
| 5-10 | L6 | $400-550K |
| 10+ | L7+ | $600K+ |

### Tips
- Switching companies often means level bump
- Stock refreshers make staying attractive
- Network matters for senior roles
- Side projects can differentiate
