# Startups and Funding - Seattle

## Overview

Seattle has a significant startup ecosystem, powered by Amazon and Microsoft talent spinouts. It's not SF, but it's serious.

### Strengths
- Deep engineering talent
- Amazon/Microsoft alumni network
- Lower costs than SF
- Enterprise/B2B expertise
- Cloud infrastructure knowledge (AWS hometown)

### Weaknesses
- Less VC presence than SF
- Smaller network effects
- Fewer "swing for fences" VCs
- Can feel conservative vs SF

---

## Notable Startups and Exits

### Recent Unicorns/Exits

| Company | What | Status |
|---------|------|--------|
| Snowflake | Data cloud | IPO (Bellevue origin) |
| Auth0 | Identity | Acquired by Okta |
| Rover | Pet sitting | Public |
| Outreach | Sales engagement | Unicorn |
| Highspot | Sales enablement | Unicorn |
| Zipwhip | Business texting | Acquired |
| Convoy | Freight | (Shut down 2023) |
| Remitly | Remittances | Public |

### Categories Strong in Seattle
- Cloud infrastructure
- Enterprise SaaS
- Developer tools
- E-commerce
- Logistics
- AI/ML

---

## Funding Landscape

### Local VCs

| Firm | Focus |
|------|-------|
| Madrona Venture Group | Enterprise, cloud (most prominent local) |
| Pioneer Square Labs | Studio model |
| Flying Fish Partners | B2B |
| M12 (Microsoft) | Corporate VC |
| Founders' Co-op | Seed |
| Trilogy Equity Partners | Growth |

### Active Non-Local VCs
- Andreessen Horowitz
- Sequoia
- Accel
- General Catalyst
- Index Ventures

**Reality:** Most Series A+ still involves SF/national VCs.

---

## Accelerators and Programs

| Program | Focus |
|---------|-------|
| Techstars Seattle | General |
| Pioneer Square Labs | Studio (company building) |
| 9Mile Labs | B2B |
| Founders Live | Pitch events |
| UW CoMotion | University spinouts |

---

## Startup Hubs

### Physical Locations
| Space | Type | Notes |
|-------|------|-------|
| WeWork | Coworking | Multiple locations |
| Galvanize | Tech education + coworking | Pioneer Square |
| Impact Hub | Social enterprise | Pioneer Square |
| Thinkspace | Coworking | Redmond |

### Neighborhoods
- **Pioneer Square:** Historical startup hub
- **South Lake Union:** More corporate but some startups
- **Capitol Hill:** Some small companies
- **Bellevue:** Growing startup presence

---

## Startup Culture

### Compared to SF
| Factor | Seattle | SF |
|--------|---------|-----|
| Risk appetite | More conservative | YOLO |
| Funding access | Good but less | Best |
| Talent pool | Deep, experienced | Largest |
| Cost | High but manageable | Extreme |
| Work-life | Better | More hustle |
| Exit expectations | B2B, acquisition common | IPO dreams |

### Typical Seattle Founder
- Ex-Amazon or Microsoft
- B2B/enterprise focus
- More capital efficient
- Less "move fast break things"
- Engineering-first

---

## Compensation

### Early Stage (Seed/Series A)

| Role | Cash | Equity |
|------|------|--------|
| Founding engineer | $120-180K | 0.5-2% |
| First 10 | $130-180K | 0.1-0.5% |
| Engineer #20-50 | $150-200K | 0.05-0.2% |

### Growth Stage (Series B+)

| Role | Cash | Equity |
|------|------|--------|
| Senior engineer | $180-250K | 0.02-0.1% |
| Director | $220-300K | 0.05-0.2% |
| VP | $280-400K | 0.1-0.5% |

**Note:** Cash often lower than Big Tech, equity is the bet.

---

## Joining a Startup

### Due Diligence
1. **Funding:** Runway, last raise, burn rate
2. **Investors:** Quality of VC backing
3. **Founders:** Track record, vision
4. **Traction:** Revenue, growth, customers
5. **Equity:** Cap table, preferences, vesting

### Questions to Ask
- What's the runway?
- What's the path to next round?
- What's the cap table look like?
- What are the liquidation preferences?
- What happens if acquired for less than raised?

### Red Flags
- Won't share cap table
- Excessive liquidation preferences
- Founders taking large salaries
- Vague answers about runway
- High burn with low traction

---

## Starting a Company

### Resources
- Washington State incorporation (easy)
- WBDC (small business resources)
- SCORE Seattle (mentorship)
- Startup weekend events
- Madrona content (blog, events)

### Legal/Accounting
- Perkins Coie (startup practice)
- Wilson Sonsini (national)
- Many startup-focused accountants

### Banking
- First Republic (acquired by Chase)
- Silicon Valley Bank (regional, cautious)
- Brex/Mercury (modern options)

---

## Seattle vs Other Cities

### Stay in Seattle If
- Enterprise/B2B focus
- Want quality of life
- Have local network
- Cloud/infrastructure expertise
- Value capital efficiency

### Consider SF If
- Consumer focused
- Need maximum VC access
- Want largest talent pool
- "Swing for fences" mentality

### Consider Austin/Denver If
- Cost matters most
- Remote-first anyway
- Lifestyle priority
