# Safety - Seattle

## Overall Assessment

Seattle is **generally safe** but has **visible homelessness and property crime**. Violent crime is lower than many US cities, but car break-ins and package theft are common.

| Metric | Seattle Reality |
|--------|-----------------|
| Violent crime | Lower than US average |
| Property crime | Higher than US average |
| Homelessness | Highly visible |
| Feel | Safe but vigilant |

---

## Neighborhood Safety

### Very Safe
| Neighborhood | Notes |
|--------------|-------|
| Magnolia | Isolated, residential |
| Upper Queen Anne | Residential, families |
| Wallingford | Family neighborhood |
| Kirkland | Eastside, affluent |
| Bellevue | Eastside, well-policed |
| West Seattle | Community feel |

### Generally Safe
| Neighborhood | Notes |
|--------------|-------|
| Capitol Hill | Safe but has some issues |
| Ballard | Safe, some property crime |
| Fremont | Safe, quirky |
| Green Lake | Safe, residential |
| Columbia City | Improving |

### Mixed/Variable
| Neighborhood | Notes |
|--------------|-------|
| Downtown | Tourist areas okay, some blocks rough |
| Belltown | Nightlife area, late-night issues |
| Pioneer Square | Historic but homeless presence |
| International District | Struggling, be aware |
| Beacon Hill | Mostly fine, some blocks |

### Exercise Caution
| Area | Situation |
|------|-----------|
| Parts of SODO | Industrial, isolated |
| Third Avenue downtown | Known problem area |
| Some Pioneer Square blocks | Night especially |
| Aurora Ave (parts) | Historical issues |

---

## Common Crimes

### Property Crime (Most Common)

**Car Break-ins**
- Very common, especially near trailheads
- Never leave ANYTHING visible
- "Nothing to steal" signs don't work
- Report to police (for insurance)

**Package Theft**
- Common in apartments
- Use Amazon lockers
- Require signature
- Camera doorbells help

**Bike Theft**
- Extremely common
- U-lock minimum, two locks better
- Register with police
- Don't leave overnight outside

### Violent Crime (Less Common)
- Generally concentrated in specific areas
- Late night + intoxication increases risk
- Downtown and Belltown have incidents
- Most neighborhoods very safe

---

## Homelessness

### Reality
- Highly visible in Seattle
- Tent encampments exist
- Not unique to Seattle (West Coast issue)
- Rarely dangerous, mostly tragic

### Where You'll See It
- Downtown (Third Avenue especially)
- Under bridges, overpasses
- Some parks
- Pioneer Square
- International District

### How to Handle
- Walk past normally
- Don't engage if uncomfortable
- Aggressive behavior rare
- Call 911 for emergencies only
- Compassion helps everyone

---

## Safety Tips

### General
1. **Trust your instincts** — If it feels wrong, leave
2. **Stay aware** — Headphones low, eyes up
3. **Walk purposefully** — Look like you belong
4. **Stick to lit areas** at night
5. **Travel in groups** late night

### Car Safety
1. **Never leave anything visible** — Nothing, not even a quarter
2. **Don't park at trailheads for long periods**
3. **Use secure parking garages** downtown
4. **Check your car** before getting in

### Home Safety
1. **Know your neighbors** — Community helps
2. **Package lockers** when possible
3. **Good locks** on doors and windows
4. **Camera doorbell** deters theft
5. **Don't leave packages outside**

### Bike Safety
1. **Two locks** (U-lock + cable)
2. **Register your bike** with police
3. **Take photos** of serial number
4. **Bring inside** whenever possible
5. **Lock through frame** not just wheel

---

## Women's Safety

### General
Seattle is relatively safe for women, but standard precautions apply:
- Share location with friends
- Rideshare safer than walking alone late
- Some bars/clubs have "angel shot" programs
- Trust instincts about people/situations

### Areas to Be Careful
- Third Avenue downtown at night
- Isolated areas late
- Parts of Belltown late night
- Some Pioneer Square blocks

### Resources
- Crisis line: 206-461-3222
- YWCA Seattle: Support services
- Harborview Center for Sexual Assault

---

## LGBTQ+ Safety

### Overview
Seattle is very LGBTQ+ friendly. Capitol Hill is the historic gayborhood.

- One of the most accepting US cities
- Pride is huge (June)
- Legal protections strong
- Visible community

### Rare Issues
- Occasional harassment (drunk people)
- Less welcoming in some suburbs
- Standard awareness applies

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| Emergency | 911 |
| Non-emergency police | 206-625-5011 |
| Crisis line | 988 |
| Poison control | 1-800-222-1222 |
| Seattle City Light (outages) | 206-684-3000 |

---

## Natural Disasters

### Earthquakes
- Seattle is in earthquake zone
- Major quake possible (not common)
- Know "drop, cover, hold"
- Have emergency supplies

### Wildfires (Smoke)
- Not in Seattle but smoke drifts from Eastern WA
- August-September worst
- Check AQI before outdoor activities
- N95 masks help

### Winter Weather
- Snow rare but shuts city down
- Ice is bigger problem
- Hills become dangerous
- City not equipped for snow

### Flooding
- Some areas prone
- Check before renting
- Usually localized

---

## Insurance Recommendations

| Coverage | Why |
|----------|-----|
| Renters insurance | Covers theft, damage |
| Car insurance | Required, comprehensive for break-ins |
| Bike insurance | Theft common, consider it |
| Umbrella policy | Extra liability protection |

**Renters insurance is cheap (~$15/month) and worth it.**
