# Moving and Settling - Seattle

## Before You Move

### Research Phase
1. **Visit first** if possible (ideally different seasons)
2. **Understand the grey** — 200+ overcast days is real
3. **Job first** — Seattle is expensive without good income
4. **Neighborhood research** — City is spread out, where you live matters

### Budget Reality

| Expense | Monthly Cost |
|---------|--------------|
| Rent (1BR) | $1,800-3,000 |
| Utilities | $100-150 |
| Internet | $60-100 |
| Car (if needed) | $400-600 total |
| Groceries | $400-600 |
| Health insurance | Employer or $300-600 |
| Entertainment | $200-500 |
| **Total** | **$3,500-5,500** |

**Rule of thumb:** Need $70K+ income for comfortable single life, $120K+ for family.

---

## Finding Housing

### Timeline
- **2-3 months out:** Start looking at neighborhoods
- **1-2 months out:** Active searching
- **2-4 weeks out:** Tour, apply, sign

### Platforms

| Platform | Best For |
|----------|----------|
| Zillow | Most listings |
| Apartments.com | Large buildings |
| Craigslist | Smaller units, deals |
| Facebook Groups | Roommates, sublets |
| Padmapper | Map-based search |

### Application Process
- Application fee: $30-50 per property
- Credit check required
- Income verification (usually 2.5-3x rent)
- First month + deposit typical
- Some require last month too

### Tips
- **Tour in person** if possible
- **Check commute** at rush hour
- **Ask about parking** (extra $150-300/month downtown)
- **Utilities included?** Often not
- **Lease length** — Most want 12 months

---

## First Week Tasks

### Immediate
1. Set up utilities (Seattle City Light, internet)
2. Get Washington driver's license (30 days)
3. Register vehicle (30 days)
4. Find grocery store
5. Locate nearest urgent care

### First Month
1. Set up primary care doctor
2. Get ORCA card (transit)
3. Explore neighborhood
4. Find gym/activities
5. Join local groups (Meetup, clubs)

---

## Utilities Setup

### Electricity
- **Provider:** Seattle City Light (city-owned)
- **Setup:** Online or phone
- **Cost:** $50-100/month typical

### Gas
- **Provider:** Puget Sound Energy
- **Not all units have gas** (many all-electric)
- **Cost:** $30-60/month if used

### Water/Sewer
- **Provider:** Seattle Public Utilities
- **Often included in rent** for apartments

### Garbage
- **Provider:** Seattle Public Utilities
- **Composting required** (green bin)
- **Recycling required** (blue bin)

### Internet
| Provider | Speed | Price |
|----------|-------|-------|
| CenturyLink | Up to 1Gbps | $50-65 |
| Xfinity | Up to 1.2Gbps | $50-80 |
| Ziply Fiber | Up to 1Gbps | $60 |
| Starlink | Variable | $120 |

**Check address** for availability — varies by location.

---

## Driver's License

### Requirements
- Pass written test (study guide online)
- Pass vision test
- Pass driving test (if no out-of-state license)
- Proof of identity
- Proof of residency
- Social Security number

### Locations
- DOL offices throughout area
- Schedule online (less wait)
- Expect 1-2 hours

### Vehicle Registration
- Sales tax on purchase: 10.25%+
- Registration: ~$100-200/year
- Emissions test required (some counties)

---

## Healthcare

### Finding a Doctor
- Most need referral for specialists
- Insurance networks matter
- Major health systems:
  - Virginia Mason Franciscan
  - UW Medicine
  - Swedish
  - Kaiser Permanente

### Urgent Care
- ZoomCare (walk-in, many locations)
- Swedish Urgent Care
- UW Neighborhood Clinics

### Emergency
- Harborview (Level 1 trauma)
- Swedish First Hill
- Virginia Mason

---

## Banking

### Local Options
- BECU (credit union, popular)
- WSECU (credit union)
- Banner Bank (regional)

### National Banks
- Chase, Bank of America, Wells Fargo all present
- Most have downtown branches

### Tips
- Credit unions often have better rates
- Many ATMs charge fees
- Mobile banking works everywhere

---

## Social Life

### The Seattle Freeze
**It's real.** Making friends takes effort.

- People are polite but not warm
- Invitations may not be forthcoming
- Takes 1-2 years to build friend group
- Transplants often befriend other transplants

### Breaking Through
1. **Join activities** — Hiking groups, sports leagues, hobby clubs
2. **Meetup.com** — Many active groups
3. **Work connections** — Common friend source
4. **Be persistent** — Keep showing up
5. **Initiate** — Don't wait for invitations

### Activities to Meet People
- Hiking groups (mountains are social)
- Running clubs
- Climbing gyms
- Rec sports leagues
- Board game groups
- Volunteer organizations

---

## Seasons Adjustment

### Winter (Oct-Mar)
- **Grey, grey, grey**
- Light therapy lamp recommended
- Vitamin D supplements common
- Indoor activities important
- Plan trips to sunnier places

### Summer (Jul-Sep)
- Everyone goes outside
- Book activities ahead
- Mountain trips popular
- Ferry to islands
- Best time to explore

### Tips
- **Embrace outdoors** when sunny
- **Have indoor hobbies** for grey months
- **Light therapy** helps many people
- **Stay active** to combat seasonal mood dip

---

## Cost Saving Tips

### Housing
- Roommates common even for professionals
- Look slightly north or south of hot neighborhoods
- Beacon Hill, Rainier Valley more affordable
- Eastside can be comparable to Seattle

### Transportation
- Skip the car if possible (Capitol Hill, downtown)
- Light rail expanding rapidly
- Bike + transit combo works

### Food
- Cook at home (restaurants expensive)
- Happy hours are great value
- Asian markets cheaper than Whole Foods
- Farmers markets for produce

### Entertainment
- Many free parks and trails
- Library system excellent
- Happy hour culture
- Brewery hopping is cheap
