# Remote Workers - Seattle

## Why Seattle for Remote Work

### Pros
| Factor | Details |
|--------|---------|
| No state income tax | Keep more of remote salary |
| Quality of life | Nature, coffee, food |
| Tech culture | Understand remote workers |
| Good internet | Fiber available in many areas |
| Time zone | PST works for national companies |
| Airport | SEA has good connections |

### Cons
| Factor | Details |
|--------|---------|
| Cost of living | High for remote salary |
| Weather | Grey winters can be isolating |
| Seattle Freeze | Harder to make friends |
| Time zone | Bad for EU collaboration |

---

## Best Neighborhoods for Remote Work

### Capitol Hill
**Why:** Coffee shops everywhere, walkable, social
- Work from cafes easy
- Coworking options
- Nightlife for post-work
- Light rail to airport

### Ballard
**Why:** Quieter, still has coffee shops and community
- Good home setup neighborhoods
- Breweries for after-work
- Community feel

### Fremont/Wallingford
**Why:** Quiet, residential, good for focus
- Fewer distractions
- Nice for home offices
- Parks for breaks

### Beacon Hill/Columbia City
**Why:** Affordable, light rail, diverse
- Better value
- Transit to downtown/airport
- Growing coffee scene

---

## Coworking Spaces

| Space | Location | Price | Notes |
|-------|----------|-------|-------|
| WeWork | Multiple | $350-600/mo | National chain |
| Industrious | Downtown, Bellevue | $400-700/mo | Professional |
| The Pioneer Collective | Pioneer Square | $300-500/mo | Local |
| Office Nomads | Capitol Hill | $300-500/mo | Community focused |
| Galvanize | Pioneer Square | Varies | Tech focused |

### Day Passes
Most coworking spaces offer day passes ($20-50) if you need occasional desk space.

---

## Coffee Shop Work

### Best for Working

| Shop | Location | Why Good |
|------|----------|----------|
| Victrola | Capitol Hill | Big, good WiFi, outlets |
| Elm Coffee | Pioneer Square | Quiet, spacious |
| Milstead | Fremont | Lots of seating |
| Zoka | U-District | Long tables, student vibe |
| Storyville | Pike Place | Beautiful but can be crowded |

### Etiquette
- Buy something every 2-3 hours
- Don't hog tables at peak times
- Respect others' space
- Keep calls quiet or step outside

### Chains That Work
- Starbucks (WiFi, outlets, consistent)
- Caffe Ladro (local chain, good for work)

---

## Home Office Setup

### Internet Options

| Provider | Speed | Price | Notes |
|----------|-------|-------|-------|
| Ziply Fiber | 1Gbps | $60 | Best where available |
| Xfinity | 1.2Gbps | $60-80 | Most available |
| CenturyLink | 1Gbps | $65 | Fiber limited |

**Check your address** before signing lease.

### Furniture
- IKEA (Renton)
- West Elm
- Amazon (obviously)
- Facebook Marketplace for deals

### Standing Desks
- Many Amazon employees sell used ones
- Herman Miller Aeron chairs on secondary market

---

## Taxes

### The Big Win
Washington has **no state income tax**. If you work remotely for a company in CA, you pay no state income tax (you pay where you live, not where company is).

**Savings example:**
| Salary | CA Tax | WA Tax | Annual Savings |
|--------|--------|--------|----------------|
| $150K | $15K+ | $0 | ~$15K |
| $200K | $22K+ | $0 | ~$22K |

### Tax Considerations
- Still pay federal income tax
- Sales tax is 10.25% (higher than many states)
- Some employer complexity with multi-state

---

## Staying Social

### The Challenge
- Seattle Freeze is real
- Remote work adds isolation
- Grey winters compound it

### Solutions

**Structured Activities:**
- Climbing gyms (social, active)
- Running clubs
- Hiking groups
- Board game meetups
- Rec sports leagues

**Work-Adjacent:**
- Coworking spaces (built-in community)
- Local tech meetups
- Remote worker meetups (exist!)

**Tips:**
- Join something with regular schedule
- Same people, same time each week
- Be the one who initiates plans

---

## Time Zone Management

### PST Advantages
- Mornings free if East Coast team
- Reasonable overlap with Hawaii/Alaska
- California, Southwest overlap perfectly

### PST Challenges
- EU collaboration is hard (9+ hour gap)
- East Coast ends day at your 2pm
- Early meetings (6am) for East Coast 9am

### Strategies
- Async communication heavy
- Core overlap hours defined
- Record meetings for later
- Protect personal time

---

## Day-to-Day Routine

### Suggested Structure
| Time | Activity |
|------|----------|
| 7-8am | Morning routine, coffee |
| 8-12pm | Deep work (East Coast overlap) |
| 12-1pm | Lunch, walk |
| 1-3pm | Meetings (overlap hours) |
| 3-5pm | Async work, wrap up |
| 5pm+ | Personal time |

### Breaks
- Walk around Green Lake
- Coffee shop switch
- Quick hike (trailheads close)
- Gym session

---

## When to Fly Out

### Common Patterns
- Quarterly onsites (many companies)
- Team summits
- Client meetings
- Conferences

### SEA Airport
- Good domestic connections
- Alaska Airlines hub
- Direct to most major cities
- 30-40 min from downtown (light rail)

### Tips
- Light rail to airport is easy
- TSA PreCheck/Clear worth it
- Alaska credit card for perks

---

## Cost Comparison

### Remote Salary + Seattle
If you have a remote salary (especially SF/NYC level), Seattle is great value:

| Expense | SF | NYC | Seattle |
|---------|-----|-----|---------|
| 1BR rent | $3,500 | $4,000 | $2,200 |
| State tax (on $200K) | $22K | $15K | $0 |
| Food | Higher | Higher | High |
| **Net savings** | - | - | $20K+/year |

### But Consider
- If salary is adjusted to Seattle market, advantage shrinks
- COL is still high vs Austin, Denver, etc.
- Weather tax is real (grey affects some people)
