# North Seattle Neighborhoods

## Ballard

### Overview
- Seattle's hippest established neighborhood
- Nordic heritage meets craft breweries
- Excellent dining and bar scene
- Growing rapidly but keeping character

### Character
- Former Scandinavian fishing village
- Now: breweries, restaurants, boutiques
- Mix of old-timers and young professionals
- Still has working Locks and fishing industry

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 80 | Ballard Ave very walkable |
| Transit | Good | Buses, future light rail |
| Nightlife | Excellent | Breweries, bars |
| Dining | Excellent | Top restaurants |
| Grocery | Good | PCC, Trader Joe's |
| Safety | Good | Very safe |
| Rent (1BR) | $1,700-2,200 | Rising |

### Who Lives Here
- 30-something professionals
- Young families
- Food/beer enthusiasts
- Creative professionals

### Pros
- Best brewery neighborhood
- Excellent restaurants
- Ballard Locks (free attraction)
- Farmers market (year-round)
- Character despite growth
- Future light rail coming

### Cons
- Traffic increasing
- Rapidly changing
- Getting expensive
- Parking difficult on weekends
- Less transit than Cap Hill

### Sub-Areas

**Ballard Ave/Old Ballard**
- Historic heart
- Best bars and restaurants
- Sunday farmers market

**Ballard Locks Area**
- Near Locks and Golden Gardens
- Quieter, residential
- Beach access

**East Ballard**
- More residential
- Closer to Fremont
- Good value

### Dining Highlights
- The Walrus and the Carpenter (oysters)
- Stoneburner (Mediterranean)
- La Carta de Oaxaca (Mexican)
- Bastille (French)

### Brewery Scene
- Reuben's Brews
- Stoup Brewing
- Lucky Envelope
- Peddler Brewing
- 15+ more within walking distance

### Key Attractions
- Ballard Locks (free, fascinating)
- Golden Gardens Beach
- Nordic Museum
- Sunday Farmers Market

---

## Fremont

### Overview
- "Center of the Universe" (self-declared)
- Quirky, artsy, independent
- Fremont Troll, Lenin statue
- Chill vibe, local shops

### Character
- Proudly weird
- Summer solstice parade (naked cyclists)
- Independent businesses
- Anti-corporate ethos
- Walkable center

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 75 | Center is walkable |
| Transit | Good | Buses to downtown |
| Nightlife | Moderate | Some bars, chill |
| Dining | Good | Eclectic mix |
| Grocery | Limited | Need to leave |
| Safety | Good | Very safe |
| Rent (1BR) | $1,600-2,100 | Moderate |

### Who Lives Here
- Creative types
- 30s-40s professionals
- People who like quirky
- Those over Capitol Hill chaos

### Pros
- Real neighborhood character
- Less crowded than Ballard
- Walking distance to Ballard, Wallingford
- Theo Chocolate factory
- Burke-Gilman Trail access

### Cons
- Limited grocery (go to Wallingford)
- Fewer restaurants than Ballard
- Can feel small
- Less nightlife

### Quirky Attractions
- Fremont Troll (under bridge)
- Lenin statue (yes, really)
- Rocket ship sculpture
- Solstice parade (June)

### Key Spots
- Milstead Coffee
- Theo Chocolate (tours)
- Add-a-Ball (bar arcade)
- Eve (cocktails)

---

## Wallingford

### Overview
- Family-friendly neighborhood
- Cute main street (45th St)
- Near U-District and Fremont
- Quiet, residential

### Character
- Small-town feel in city
- Families everywhere
- Coffee shops and brunch spots
- Green Lake nearby

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 70 | 45th St walkable |
| Transit | Good | Buses |
| Nightlife | Limited | Go elsewhere |
| Dining | Good | Brunch, casual |
| Grocery | Good | QFC, Trader Joe's |
| Safety | Excellent | Very safe |
| Rent (1BR) | $1,600-2,000 | Moderate |

### Who Lives Here
- Families (primarily)
- Professors (near UW)
- People wanting quiet
- Those who love Green Lake

### Pros
- Green Lake access
- Quiet, safe
- Good brunch spots
- Family-friendly
- Reasonable prices

### Cons
- Boring for nightlife
- Can feel sleepy
- Car helpful
- Not much happening

### Key Spots
- Green Lake (walk/run/bike loop)
- Irwin's (bakery)
- Joule (Korean)
- Kisaku (sushi)

---

## Green Lake

### Overview
- Named after the lake
- Runners, walkers, families
- Athletic, outdoorsy vibe
- Beautiful year-round

### Character
- Health-conscious
- Families and athletes
- 2.8 mile walking/running loop
- Outdoor recreation focused

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 65 | Near lake is great |
| Transit | Moderate | Buses |
| Nightlife | Limited | Family area |
| Dining | Moderate | Basics |
| Grocery | Good | Access to stores |
| Safety | Excellent | Very safe |
| Rent (1BR) | $1,600-2,100 | Moderate |

### The Lake
- 2.8 mile loop (walk, run, bike)
- Swimming in summer
- Paddleboarding, kayaking
- THE reason to live here

---

## University District (U-District)

### Overview
- University of Washington campus
- Student-dominated
- Cheap eats, young energy
- Light rail access now

### Character
- Young (mostly students)
- Affordable restaurants
- Ave (main commercial strip)
- Diverse, international

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 80 | The Ave is walkable |
| Transit | Excellent | Light rail |
| Nightlife | College bars | Not sophisticated |
| Dining | Good value | Cheap eats |
| Grocery | Good | Safeway, Trader Joe's |
| Safety | Mixed | Some issues |
| Rent (1BR) | $1,200-1,700 | Cheapest central |

### Who Lives Here
- UW students (mostly)
- Graduate students
- Young professionals on budget
- International students

### Pros
- Affordable
- Light rail to downtown
- Cheap, diverse food
- Young energy
- Beautiful campus to walk

### Cons
- Student-dominated
- Some safety issues
- Can feel transient
- Loud
- Limited sophistication

### Best For
- Students
- Budget-conscious newcomers
- Those wanting transit access cheaply
- People who don't mind young crowds
