# Eastside Neighborhoods

## Overview

The Eastside refers to cities east of Lake Washington, connected by 520 and I-90 bridges. Major cities: Bellevue, Kirkland, Redmond, Woodinville, Issaquah.

**Key difference from Seattle:**
- More suburban/car-dependent
- Higher Asian population
- Better schools on average
- Higher rents often
- Microsoft territory (vs Amazon in Seattle)
- Safer feeling
- Less urban character

---

## Bellevue

### Overview
- "The other downtown"
- Microsoft-adjacent, major tech hub
- Upscale, clean, diverse
- Growing rapidly

### Character
- Suburban meets urban
- Mall culture (Bellevue Square)
- Very international (Chinese, Indian, Korean)
- Safe, clean, corporate
- Family-oriented

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 60-70 | Downtown yes, elsewhere no |
| Transit | Moderate | Buses, light rail coming 2024 |
| Nightlife | Limited | Improving |
| Dining | Excellent | Asian cuisine especially |
| Grocery | Excellent | Multiple options |
| Safety | Excellent | Very safe |
| Rent (1BR) | $2,200-3,200 | Higher than Seattle |

### Who Lives Here
- Microsoft workers
- Tech workers (Meta, Google, etc.)
- Families wanting good schools
- Asian immigrants
- Wealthy professionals

### Pros
- Excellent schools
- Very safe
- Great Asian food
- Close to Microsoft
- Clean, well-maintained
- Growing urban amenities

### Cons
- Suburban feel
- Need car for most things
- Less character than Seattle
- Mall-centric culture
- Expensive

### Key Areas

**Downtown Bellevue**
- High-rises, walkable (for Eastside)
- Bellevue Square mall
- Best restaurants
- Light rail coming

**West Bellevue**
- Near Seattle (shorter bridge)
- Older, more established
- Expensive homes

**Crossroads**
- Very diverse
- International food
- More affordable
- Good transit

### Dining Highlights
- Din Tai Fung (dumplings)
- Facing East (Taiwanese)
- Korean BBQ row (multiple)
- Fern Thai (Thai)

---

## Kirkland

### Overview
- Charming waterfront town
- Lake Washington access
- More character than Bellevue
- Growing tech presence

### Character
- Small-town feel with urban amenities
- Waterfront is main draw
- Restaurants, galleries
- Family-friendly but hip

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 50 | Downtown yes, elsewhere no |
| Transit | Moderate | Buses |
| Nightlife | Limited | Some wine bars |
| Dining | Good | Waterfront spots |
| Grocery | Good | Multiple options |
| Safety | Excellent | Very safe |
| Rent (1BR) | $2,000-2,800 | High |

### Who Lives Here
- Families
- Tech workers (Google Kirkland)
- Waterfront lovers
- Those who want Eastside with character

### Pros
- Beautiful waterfront
- Charming downtown
- More character than Bellevue
- Safe, family-friendly
- Beach parks

### Cons
- Car dependent outside downtown
- Expensive
- Limited nightlife
- Bridge commute to Seattle brutal

### Key Spots
- Marina Park (beach)
- Carillon Point (waterfront dining)
- Downtown Kirkland shops
- Cross Kirkland Corridor (trail)

---

## Redmond

### Overview
- Microsoft HQ
- "Bicycle Capital of NW"
- Suburban, family-oriented
- Town center redeveloping

### Character
- Quiet suburban
- Microsoft dominates
- Good trails (Sammamish River Trail)
- Family-focused

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 40 | Town center okay |
| Transit | Moderate | Buses, light rail coming |
| Nightlife | Minimal | Very quiet |
| Dining | Moderate | Some options |
| Grocery | Good | Multiple |
| Safety | Excellent | Very safe |
| Rent (1BR) | $2,000-2,700 | High |

### Who Lives Here
- Microsoft employees (primarily)
- Families
- People who like suburban quiet
- Outdoor enthusiasts

### Pros
- Microsoft campus walking distance
- Excellent trails
- Very safe
- Light rail coming (finally)
- More affordable than Bellevue

### Cons
- Very suburban
- Car essential
- Nothing to do at night
- Far from Seattle
- Can feel boring

### Key Spots
- Marymoor Park (huge regional park)
- Redmond Town Center
- Microsoft Visitor Center
- Sammamish River Trail

---

## Woodinville

### Overview
- Wine country
- 100+ wineries/tasting rooms
- Rural feel, close to tech hubs
- Touristy weekends

### Character
- Wine-focused
- Semi-rural
- Weekend destination
- Family and wine enthusiasts

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 20 | Car required |
| Transit | Poor | Car essential |
| Nightlife | Wine bars | That's about it |
| Dining | Good | Wine country options |
| Grocery | Moderate | QFC |
| Safety | Excellent | Very safe |
| Rent (1BR) | $1,800-2,400 | More affordable |

### Best For
- Wine enthusiasts
- Those wanting space
- People okay with commute
- Families wanting rural-ish

---

## Bridge Commute Reality

**520 Bridge (Seattle to Bellevue/Kirkland)**
- Rush hour: 30-60+ minutes
- Toll: $2-6 depending on time
- Light rail coming (will help)

**I-90 Bridge (Seattle to Bellevue/Issaquah)**
- Rush hour: 30-50+ minutes
- No toll
- Already has light rail (East Link)

**Golden rule:**
- Work at Microsoft/Eastside = Live on Eastside
- Work at Amazon/Seattle = Live in Seattle
- Cross-lake commute kills quality of life

---

## Eastside Summary

| City | Best For | Rent 1BR | Character |
|------|----------|----------|-----------|
| Bellevue | Tech, families, safety | $2,200-3,200 | Suburban-urban |
| Kirkland | Waterfront, charm | $2,000-2,800 | Small-town |
| Redmond | Microsoft, families | $2,000-2,700 | Suburban |
| Woodinville | Wine, space | $1,800-2,400 | Rural |
| Issaquah | Mountains, families | $1,900-2,600 | Mountain town |
