# Capitol Hill and Central District - Seattle

## Capitol Hill

### Overview
- Seattle's most walkable neighborhood
- LGBTQ+ heart of Seattle
- Best nightlife, coffee, and street life
- Where young Seattle lives

### Character
- Progressive, diverse, loud
- Rainbow crosswalks, pride year-round
- Historic mansions next to modern apartments
- Coffee shops every block
- Music venues, bookstores, vintage shops

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 95 | Best in Seattle |
| Transit | Excellent | Light rail station |
| Nightlife | Best in city | Bars, clubs, venues |
| Dining | Excellent | Every cuisine |
| Grocery | Good | QFC, Trader Joe's nearby |
| Grocery | Good | QFC, Trader Joe's nearby |
| Safety | Generally good | Some late-night issues |
| Rent (1BR) | $1,800-2,400 | Premium for location |

### Who Lives Here
- Young professionals (25-35)
- LGBTQ+ community
- Artists and musicians
- Service industry workers
- Tech workers who want urban life

### Pros
- Best walkability in Seattle
- Light rail station
- Everything you need within walking
- Incredible restaurant/bar scene
- Community feel despite density
- Walk to downtown (~15 min)

### Cons
- Loud (especially weekends)
- Parking nightmare
- Getting expensive
- Some late-night issues
- Party crowds on Broadway

### Sub-Areas

**Broadway (Main Strip)**
- Busiest, most commercial
- Restaurants, bars, shops
- Rainbow crosswalks
- Loud on weekend nights

**15th Ave E (Quieter)**
- More residential
- Still walkable
- Good restaurants
- Calmer than Broadway

**Madison Valley/Madison Park (Edge)**
- Quieter, wealthier
- Lake Washington access
- More family-friendly
- Higher rents

**Cal Anderson Park Area**
- Central gathering spot
- Surrounded by apartments
- Good location

### Coffee Highlights
- Victrola (institution)
- Espresso Vivace (legendary espresso)
- Stumptown
- Dozens more

### Dining Highlights
- Altura (Italian, splurge)
- Sitka and Spruce (NW cuisine)
- Stateside (Vietnamese)
- Ba Bar (Vietnamese)
- Too many to list

### Nightlife Highlights
- Neumos (live music)
- Kremwerk/Timbre Room (electronic)
- The Unicorn (quirky bar)
- Sun Liquor (cocktails)
- R Place (LGBTQ+ institution)
- CC's (LGBTQ+ classic)

---

## Central District (CD)

### Overview
- Historic Black neighborhood
- Rapidly gentrifying
- Between Capitol Hill and Beacon Hill
- Jazz heritage

### Character
- Changing rapidly
- Mix of long-time residents and newcomers
- More residential than Cap Hill
- Strong community feeling

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 70 | Improving |
| Transit | Good | Buses, near light rail |
| Nightlife | Limited | Go to Cap Hill |
| Dining | Good | Soul food, new spots |
| Grocery | Improving | Central Co-op |
| Safety | Variable | Block dependent |
| Rent (1BR) | $1,500-2,000 | Rising fast |

### Who Lives Here
- Long-time Black community (shrinking)
- Young professionals priced out of Cap Hill
- Families
- Artists

### Pros
- More affordable than Cap Hill
- Close to downtown, Cap Hill
- Community character
- Less crowded

### Cons
- Gentrification tension real
- Safety varies by block
- Fewer amenities than Cap Hill
- Less transit coverage

### Sub-Areas

**23rd Ave Corridor**
- Main commercial strip
- Restaurants, shops
- Historic heart

**Judkins Park**
- New light rail station
- More residential
- Good transit now

**Madrona (Edge)**
- Wealthier, quieter
- Lake Washington access
- Beautiful homes

### Notable Spots
- Central Cinema (movies + drinks)
- Ezell's Chicken (famous fried chicken)
- Cafe Selam (Ethiopian)
- Central Co-op (grocery)

---

## First Hill

### Overview
- Medical district
- Between downtown and Capitol Hill
- Hospitals dominate
- Often overlooked

### Character
- Institutional (hospitals everywhere)
- Mixed residential
- Transit to downtown
- Gateway to Cap Hill

### Living Here

| Aspect | Rating | Notes |
|--------|--------|-------|
| Walkability | 80 | Hilly but walkable |
| Transit | Good | Streetcar, buses |
| Nightlife | None | Walk to Cap Hill |
| Dining | Limited | Hospital cafeterias |
| Grocery | Limited | Need to leave |
| Safety | Good | Hospital security |
| Rent (1BR) | $1,700-2,200 | Moderate for location |

### Who Lives Here
- Healthcare workers
- Students (Seattle U)
- People wanting downtown-adjacent cheap
- Retirees

### Pros
- Close to Cap Hill and downtown
- More affordable than both
- Hospital access
- Seattle University campus

### Cons
- Dominated by hospitals
- Limited nightlife/dining
- Hilly
- Less character
- Ambulance noise

### Best For
- Healthcare workers
- Students
- Budget-conscious downtown workers
- Those who spend time elsewhere
