# Local Services - Seattle

## Phone and Internet

### Mobile Carriers
All major carriers have good Seattle coverage:
- Verizon
- AT&T
- T-Mobile (HQ in Bellevue)
- Mint Mobile (budget)

### Home Internet

| Provider | Max Speed | Price | Notes |
|----------|-----------|-------|-------|
| Ziply Fiber | 1Gbps | $60 | Best where available |
| CenturyLink | 1Gbps | $65 | Fiber limited areas |
| Xfinity | 1.2Gbps | $60-80 | Most available |
| Wave | 1Gbps | $65 | Some areas |

**Check your address** — availability varies by building.

---

## Banking

### Credit Unions (Popular in Seattle)
| Name | Notes |
|------|-------|
| BECU | Largest in WA, good rates |
| WSECU | State employees originally, open to all |
| First Tech | Tech worker focused |

### National Banks
- Chase (many ATMs)
- Bank of America
- Wells Fargo
- US Bank

### Tips
- Credit unions often better rates
- Many employers have credit union partnerships
- ATM fees common, plan accordingly

---

## Mail and Packages

### Post Office
- Standard USPS service
- Main office downtown
- Many neighborhood locations

### Package Theft Solutions
- Amazon Locker (free)
- UPS Access Point
- Building package rooms
- Require signature
- Ring/camera doorbells

---

## Libraries

### Seattle Public Library
- Excellent system
- Central Library downtown (architecturally famous)
- 27 branches
- Free with residency
- E-books, audiobooks, streaming
- WiFi hotspot lending

### Services
- Book borrowing
- Digital media
- Computer access
- Meeting rooms
- Job search help
- ESL classes

---

## Healthcare

### Major Health Systems

| System | Notes |
|--------|-------|
| UW Medicine | Academic, Harborview (trauma) |
| Swedish | Largest, multiple locations |
| Virginia Mason Franciscan | Good reputation |
| Kaiser Permanente | HMO model |
| MultiCare | South of Seattle |

### Finding a Doctor
1. Check your insurance network
2. Use Zocdoc or insurance finder
3. UW and Swedish both good
4. Expect 2-4 week waits for new patients

### Urgent Care
| Provider | Notes |
|----------|-------|
| ZoomCare | Walk-in, many locations |
| Swedish Urgent Care | Multiple locations |
| UW Neighborhood Clinics | Good coverage |
| Indigo Urgent Care | MultiCare system |

### Emergency Rooms
- Harborview: Level 1 trauma center
- Swedish First Hill: Central
- UW Medical Center: Research hospital

### Dental
- Many options
- Insurance often separate from health
- Willamette Dental (popular)

---

## Fitness

### Gyms

| Gym | Price | Notes |
|-----|-------|-------|
| 24 Hour Fitness | $30-50 | Many locations |
| LA Fitness | $30-40 | Several locations |
| Equinox | $200+ | Luxury |
| Planet Fitness | $10-25 | Budget |
| YMCA | $50-80 | Community, pools |

### Specialty
| Type | Notable |
|------|---------|
| CrossFit | Many boxes |
| Climbing | Seattle Bouldering Project, Stone Gardens |
| Yoga | Studios everywhere |
| Swimming | city pools, YMCA |
| Cycling | Indoor cycling studios |

---

## Pets

### Dog-Friendly Seattle
Seattle is very dog-friendly:
- Many off-leash parks
- Dog-friendly patios
- Dog-friendly breweries
- Hiking trails allow dogs

### Dog Parks
- Magnuson Park (huge, off-leash beach)
- Westcrest Park
- Golden Gardens
- Many neighborhood parks

### Pet Services
- Many vet options (Banfield in PetSmart, VCA, local)
- Rover HQ is here (dog sitting)
- Doggy daycares common
- Pet supply: Mud Bay (local), PetSmart, Petco

### Renting with Pets
- Most apartments allow pets
- Pet deposit: $200-500
- Pet rent: $25-50/month
- Some breed restrictions

---

## Childcare

### Cost Reality
Childcare is expensive:
| Type | Monthly Cost |
|------|--------------|
| Infant daycare | $2,000-3,000 |
| Toddler daycare | $1,800-2,500 |
| Preschool | $1,200-2,000 |
| Nanny | $3,000-4,500 |
| Au pair | $1,500-2,000 |

### Waitlists
- Start looking during pregnancy
- Popular daycares have 12+ month waits
- Employer partnerships sometimes help

### Public Schools
- Seattle Public Schools
- Quality varies by school
- Lottery system for some programs
- Many families consider private

---

## DMV (DOL in Washington)

### Department of Licensing
- Not called DMV in Washington
- Schedule appointments online
- Walk-ins possible but long waits

### Locations
- Multiple around Seattle
- Bellevue location often less busy
- Online services for renewals

---

## Voting

### Registration
- Online registration easy
- Same-day registration available
- Automatic when getting license

### Voting
- All vote-by-mail
- Ballot mailed ~3 weeks before
- Drop boxes everywhere
- Stamp not required

---

## Recycling and Composting

### Required in Seattle
- **Blue bin:** Recycling
- **Green bin:** Compost (food scraps, yard waste)
- **Black bin:** Garbage

### What Goes Where
**Compost (green):**
- Food scraps
- Coffee grounds
- Paper towels
- Yard waste

**Recycling (blue):**
- Paper, cardboard
- Plastic bottles
- Glass
- Metal cans

**Tips:**
- Composting is required (fines possible)
- Pizza boxes go in compost
- Plastic bags NOT in recycling
- When in doubt, check seattle.gov

---

## Emergency Preparedness

### Seattle Hazards
- Earthquakes (real risk)
- Severe weather (rare)
- Power outages (winter storms)

### Emergency Kit Basics
- Water (1 gallon per person per day, 3 days)
- Non-perishable food (3 days)
- Flashlight and batteries
- First aid kit
- Important documents copies
- Cash (ATMs won't work)
- Phone charger (portable battery)

### Earthquake Specific
- Know "drop, cover, hold"
- Secure tall furniture
- Know your building's age (older = more risk)
