# Food Practical Guide - Seattle

## Reservations

### Need Reservations (Book Ahead)

| Restaurant | How Far | Platform |
|------------|---------|----------|
| Canlis | 2-4 weeks | Website |
| The Walrus | 1-2 weeks | Resy |
| Shiro's | 1-2 weeks | OpenTable |
| Eden Hill | 2+ weeks | Resy |
| Bateau | 1 week | Resy |

### Walk-In Usually Fine
- Most casual restaurants
- Capitol Hill bar-restaurants
- Dim sum (expect wait weekends)
- Breweries

### Apps
- **Resy** — Best restaurants use this
- **OpenTable** — Wider coverage
- **Yelp** — Reservations too now
- **Google** — Basic bookings

---

## Delivery

### Apps

| App | Best For | Fees |
|-----|----------|------|
| DoorDash | Most options | $3-5 + tips |
| Uber Eats | Wide coverage | $3-5 + tips |
| Caviar | Better restaurants | $5+ |
| Grubhub | Some exclusives | $3-5 |

### Tips
- Fees are high, pickup often worth it
- Check restaurant directly (sometimes cheaper)
- Amazon Prime gives Grubhub+ free
- Rain days = long wait times

---

## Tipping and Service Charges

### Standard
- **Tip:** 18-20% is standard
- **Service charge:** Some restaurants add 20% automatically
- **If service charge:** No additional tip expected

### Service Charge Restaurants
- Check bill carefully
- Usually noted on menu
- Common at higher-end spots
- Controversial but growing

---

## Dietary Restrictions

### Vegetarian/Vegan

Seattle is very vegetarian/vegan friendly.

| Restaurant | Type | Notes |
|------------|------|-------|
| Plum Bistro | Vegan | Capitol Hill institution |
| Cafe Flora | Vegetarian | Madison Valley classic |
| Araya's | Vegan Thai | Multiple locations |
| Veggie Grill | Fast casual | Chain but good |

**Most restaurants** have vegetarian options, many have vegan.

### Gluten-Free

| Restaurant | Notes |
|------------|-------|
| Niche | Gluten-free bakery |
| Flying Apron | Vegan + GF bakery |
| Most restaurants | Will accommodate |

### Halal

| Restaurant | Location |
|------------|----------|
| Marrakesh | Belltown |
| Mamnoon | Capitol Hill |
| Various | ID, Eastside |

### Kosher
- Limited options
- Some delis on Eastside
- Call ahead for most

---

## Grocery Stores

### Standard

| Store | Price | Best For |
|-------|-------|----------|
| QFC | $$ | Standard shopping |
| Safeway | $$ | Standard, some 24hr |
| Fred Meyer | $$ | Grocery + everything |
| Trader Joe's | $ | Cheap, specific items |
| Target | $$ | Basic groceries |

### Premium

| Store | Price | Best For |
|-------|-------|----------|
| PCC | $$$ | Organic, co-op |
| Whole Foods | $$$ | Selection, Amazon deals |
| Metropolitan Market | $$$$ | Upscale local |
| Central Co-op | $$$ | Capitol Hill, organic |

### Asian

| Store | Location | Best For |
|-------|----------|----------|
| Uwajimaya | ID, Bellevue | Everything Asian |
| H Mart | Multiple | Korean focus |
| 99 Ranch | Edmonds, Federal Way | Chinese focus |
| Viet Wah | ID | Vietnamese |

### Other Specialty

| Store | Location | Best For |
|-------|----------|----------|
| Salumi | Pioneer Square | Italian meats |
| DeLaurenti | Pike Place | Italian imports |
| Beecher's | Pike Place | Cheese |
| MacPhee's | Multiple | Butcher |

---

## Farmers Markets

### Year-Round

| Market | Day | Location |
|--------|-----|----------|
| University District | Saturday | U-District |
| Capitol Hill | Sunday | Broadway |
| Ballard | Sunday | Ballard Ave |
| Pike Place | Daily | Downtown |

### Seasonal (Summer)

| Market | Day | Location |
|--------|-----|----------|
| West Seattle | Sunday | Junction |
| Columbia City | Wednesday | Main St |
| Fremont | Sunday | Summer only |

### Tips
- Bring cash (some vendors)
- Go early for best selection
- Ballard is largest/most popular
- Pike Place is daily but touristy

---

## Happy Hour Culture

Seattle has strong happy hour culture.

### Best Value Happy Hours

| Restaurant | Time | Best Deal |
|------------|------|-----------|
| Tamarind Tree | 3-6pm | $4 apps |
| Monsoon | 4-6pm | Half-price appetizers |
| Purple Cafe | 4-6pm | Wine + apps |
| Ray's Boathouse | 3-6pm | Oysters, views |

### Rules
- Usually 3-6pm or 4-6pm
- Often 9-close too (late)
- Bar seating usually required
- Check days (some weekdays only)

---

## Late Night Eating

Seattle is NOT a late-night food city.

### Actually Open Late (11pm+)

| Restaurant | Hours | Notes |
|------------|-------|-------|
| Beth's Cafe | 24hr | Diner classic |
| 5 Point Cafe | Late | Belltown dive |
| Lost Lake | 24hr | Capitol Hill |
| Dick's Drive-In | 2am | Burgers |

### Most restaurants close by 10pm.

---

## Brunch

Brunch culture is strong. Expect waits.

### Best Brunch

| Restaurant | Location | Known For |
|------------|----------|-----------|
| Skillet | Multiple | Bacon jam |
| Oddfellows | Capitol Hill | All-day |
| Toulouse Petit | Queen Anne | Cajun |
| Portage Bay | Multiple | Toppings bar |
| Wandering Goose | Capitol Hill | Biscuits |

### Tips
- Peak time: 10am-1pm
- Weekends = lines
- Some take reservations
- Go at 9am or 2pm to avoid crowds
