# Food Overview - Seattle

## What Makes Seattle Food Special

### The Strengths

1. **Seafood** - Fresh from Puget Sound and Alaska
   - Salmon (king, sockeye, coho)
   - Dungeness crab
   - Oysters (local varieties)
   - Geoduck (local specialty)
   - Halibut, black cod

2. **Coffee Culture** - Birthplace of modern coffee
   - Starbucks started here (1971)
   - Third-wave roasters everywhere
   - Locals are serious about coffee

3. **Asian Cuisine** - Large Asian population means authentic food
   - Vietnamese (excellent pho)
   - Chinese (dim sum, regional)
   - Korean (BBQ, fried chicken)
   - Japanese (sushi, ramen, izakaya)
   - Thai (solid options)
   - Filipino (growing scene)

4. **Pacific Northwest Cuisine** - Farm-to-table before it was trendy
   - Local ingredients focus
   - Seasonal menus
   - Foraging culture
   - Wine from Washington state

5. **Craft Beer** - Brewery culture strong
   - Ballard has 15+ breweries
   - Local hops from Yakima
   - Everything from IPAs to sours

### The Weaknesses

| Cuisine | Reality |
|---------|---------|
| Mexican | Decent but not LA/Texas level |
| BBQ | Improving but not Southern quality |
| Pizza | Good spots but not NYC |
| Southern | Limited options |
| Middle Eastern | Growing but not dominant |

---

## Price Ranges

| Level | Per Person | Examples |
|-------|------------|----------|
| Budget | $8-15 | Pho, tacos, Dick's, teriyaki |
| Casual | $20-35 | Most restaurants |
| Nice | $40-75 | Serious dining |
| Splurge | $100-200 | Canlis, fine dining |
| Omakase | $200-400 | High-end sushi |

**Tipping:** 20% standard. Some restaurants add service charge.

**Tax:** 10.25% (added to bill, not included in menu prices)

---

## Dining Trends

### Current Trends (2026)
- Service charges replacing tips (controversial)
- Filipino cuisine growing
- Natural wine bars
- Omakase sushi experiences
- Korean fried chicken obsession

### Classic Seattle
- Teriyaki (uniquely Seattle-style)
- Coffee dates over bar dates
- Casual over formal
- Happy hour culture

---

## Restaurant Culture

### Reservations
- **Need them:** Popular restaurants, weekends
- **Apps:** Resy, OpenTable, Tock
- **Walk-in friendly:** Most casual spots

### Hours
- Lunch: 11am-2pm
- Dinner: 5pm-10pm typical
- Late night: Limited options (not NYC)
- Sunday/Monday: Some restaurants closed

### Dress Code
- Very casual overall
- Even nice restaurants: "Pacific Northwest casual"
- You'll see tech workers in hoodies everywhere

---

## Food Halls and Markets

| Name | Location | Best For |
|------|----------|----------|
| Pike Place Market | Downtown | Iconic, seafood, produce |
| Melrose Market | Capitol Hill | Upscale, butcher, wine |
| The Armory | Seattle Center | Food court, families |
| Uwajimaya | International District | Asian grocery, food court |
| Capitol Hill Food Mart | Capitol Hill | Small but good |

---

## Delivery and Apps

| App | Coverage | Notes |
|-----|----------|-------|
| DoorDash | Everywhere | Most options |
| Uber Eats | Everywhere | Good coverage |
| Caviar | Urban core | Better restaurants |
| Amazon Fresh | Everywhere | Groceries |

**Fees are high.** Walking to pickup often worth it.

---

## Grocery Stores

| Store | Vibe | Price |
|-------|------|-------|
| QFC (Kroger) | Standard | $$ |
| Safeway | Standard | $$ |
| Trader Joe's | Cultish | $ |
| PCC | Co-op, organic | $$$ |
| Whole Foods | Amazon-owned | $$$ |
| Metropolitan Market | Upscale local | $$$$ |
| Uwajimaya | Asian | $$ |
| H Mart | Korean | $$ |

---

## Seasonality

| Season | Best Foods |
|--------|------------|
| Spring | Spot prawns, morels |
| Summer | Berries, stone fruit, salmon |
| Fall | Apples, mushrooms, Dungeness crab |
| Winter | Oysters, root vegetables, comfort food |

**Farmers markets:** Year-round at many locations. Sunday Ballard is biggest.
