# Local Specialties - Seattle

## Seafood

### Salmon
Seattle's signature. Multiple varieties:

| Type | Season | Flavor | Best Preparation |
|------|--------|--------|------------------|
| King (Chinook) | May-Sep | Richest, fattiest | Sashimi, grilled |
| Sockeye | Jun-Sep | Deep red, bold | Grilled, smoked |
| Coho (Silver) | Aug-Nov | Mild, versatile | Any preparation |
| Pink | Jul-Sep | Mildest | Canned, smoked |

**Where to eat:**
- Pike Place Fish Market (watch them throw)
- Ray's Boathouse (classic seafood)
- Westward (Mediterranean-influenced)
- The Walrus and the Carpenter (oysters too)

### Dungeness Crab
- Season: December-September
- Best months: Winter
- Preparation: Whole crab, cracked, butter

**Where to eat:**
- Taylor Shellfish Farms
- The Crab Pot (touristy but fun)
- Elliott's Oyster House

### Oysters
Washington is the largest oyster producer in the US. Local varieties:

| Oyster | Flavor Profile |
|--------|----------------|
| Kumamoto | Small, sweet, mild |
| Pacific | Large, creamy |
| Olympia | Tiny, metallic, rare |
| Shigoku | Crisp, clean, popular |

**Where to eat:**
- The Walrus and the Carpenter (essential)
- Taylor Shellfish Farms
- Westward
- Shuckers

### Geoduck (GOO-ee-duck)
- Giant clam native to PNW
- Looks weird, tastes clean/crunchy
- Mostly exported to Asia
- Try at sushi restaurants

---

## Seattle Teriyaki

**What is it?** Seattle-style teriyaki is a unique local cuisine created by Japanese-American immigrants. Not like Japanese teriyaki.

**Characteristics:**
- Sweet soy-based glaze
- Chicken or beef
- Served with rice and salad
- Cheap, fast, filling

**It's everywhere.** Nearly every neighborhood has a teriyaki shop.

**Classic spots:**
- Toshi's Teriyaki (original)
- Yasuko's Teriyaki
- Any neighborhood spot

---

## Coffee Culture

Seattle invented modern coffee culture.

### Third-Wave Roasters

| Roaster | Location | Known For |
|---------|----------|-----------|
| Victrola | Capitol Hill | Institution |
| Stumptown | Multiple | Portland origin, strong here |
| Elm Coffee | Pioneer Square | Minimalist, excellent |
| Milstead | Fremont | Perfectionist |
| Slate | Ballard | Deconstructed espresso |
| Caffe Vita | Multiple | Local institution |
| Espresso Vivace | Capitol Hill | Legendary espresso |

### The Order
- Locals don't do complicated Starbucks orders
- Simple: espresso drinks, pour-overs
- No judgment, but simplicity is respected

### Coffee Culture Rules
1. **Starbucks** is for tourists and convenience
2. **Third-wave shops** are where locals go
3. **Espresso** quality matters
4. **Pour-over** is common and acceptable
5. **Meeting for coffee** is the default social activity

---

## Craft Beer

### Ballard Brewery District
15+ breweries within walking distance:

| Brewery | Known For |
|---------|-----------|
| Reuben's Brews | Hazies, variety |
| Stoup Brewing | Accessible, chill |
| Peddler Brewing | Bike-friendly |
| Lucky Envelope | Asian-inspired |
| Obec Brewing | Belgian styles |

### Other Notable Breweries

| Brewery | Location | Known For |
|---------|----------|-----------|
| Georgetown Brewing | Georgetown | Mass favorite, Manny's |
| Fremont Brewing | Fremont | Urban beer garden |
| Holy Mountain | Interbay | Funk, sours |
| Cloudburst | Multiple | Experimental |

### Beer Culture
- IPAs dominate (West Coast and hazy)
- Low-ABV options growing
- Food at breweries often excellent
- Dog-friendly spaces common

---

## Washington Wine

Often overlooked, Washington is the #2 wine producer in the US.

### Regions (2-3 hours from Seattle)

| Region | Known For |
|--------|-----------|
| Woodinville | Tasting rooms (30 min) |
| Walla Walla | Premium reds (4 hours) |
| Yakima Valley | Variety (2.5 hours) |
| Columbia Valley | Large, diverse |

### Woodinville Wine
- 100+ tasting rooms
- 30 minutes from Seattle
- Day trip easy
- Saturday = crowded

**Notable Woodinville:**
- Chateau Ste. Michelle (biggest)
- DeLille Cellars
- JM Cellars
- Efeste

### What to Drink
- **Cabernet Sauvignon** - WA does this well
- **Syrah** - Underrated strength
- **Riesling** - Excellent from WA
- **Red blends** - Common and good

---

## Dick's Drive-In

Local burger chain. Cheap, cash-only, no frills.

- **Order:** Dick's Deluxe or Dick's Special
- **Price:** $3-5 burgers
- **Hours:** Late night open
- **Cash only**
- **Locations:** Capitol Hill, Wallingford, Queen Anne, others

**It's a Seattle institution.** Not gourmet, but beloved.

---

## Pike Place Market Food

### Must-Try
1. **Pike Place Chowder** - Award-winning clam chowder
2. **Piroshky Piroshky** - Russian pastries
3. **Beecher's Cheese** - Mac and cheese, fresh curds
4. **Ellenos Yogurt** - Greek yogurt
5. **Daily Dozen Donuts** - Mini donuts

### Skip
- Original Starbucks (same coffee, long line)
- Generic tourist restaurants

### Pro Tips
- Go early (9am) for fewer crowds
- Explore lower levels
- Cash helpful at small vendors
