# Cost of Living - Seattle

## Overview

Seattle is expensive but not SF/NYC level. The trade-off: **no state income tax**.

### Quick Comparison

| City | Cost Index | Notes |
|------|------------|-------|
| NYC | 187 | Baseline expensive |
| SF | 179 | Very expensive |
| Seattle | 149 | Expensive |
| LA | 146 | Similar to Seattle |
| Austin | 103 | Much cheaper |
| US Average | 100 | Baseline |

---

## Housing

### Rent (Monthly)

| Type | Seattle | Eastside |
|------|---------|----------|
| Studio | $1,400-1,800 | $1,600-2,000 |
| 1BR | $1,800-2,400 | $2,200-3,000 |
| 2BR | $2,400-3,200 | $2,800-3,800 |
| 3BR | $3,000-4,500 | $3,500-5,000 |

### By Neighborhood (1BR)

| Neighborhood | Range |
|--------------|-------|
| Capitol Hill | $1,800-2,400 |
| Ballard | $1,700-2,200 |
| South Lake Union | $2,200-3,000 |
| Beacon Hill | $1,400-1,900 |
| U-District | $1,200-1,700 |
| Bellevue | $2,200-3,200 |
| Kirkland | $2,000-2,800 |

### Buying (Median Prices)

| Type | Seattle | Eastside |
|------|---------|----------|
| Condo | $500K | $600K |
| Single Family | $850K | $1.2M |
| Townhouse | $700K | $900K |

### Hidden Costs
- First + last + deposit common
- Parking: $150-300/month extra
- Pet deposit: $200-500
- Pet rent: $25-50/month
- Utilities usually not included

---

## Taxes

### The Big Win: No State Income Tax
Washington has NO state income tax. This is huge.

| CA Income Tax | WA Income Tax | Annual Savings on $200K |
|---------------|---------------|------------------------|
| ~11% | 0% | ~$22,000 |

### Other Taxes
| Tax | Rate |
|-----|------|
| Sales tax (Seattle) | 10.25% |
| Property tax | ~1% of value |
| Car tabs | $100-200/year |
| B&O tax (businesses) | Varies |

### Net Effect
For high earners, Seattle often cheaper than CA after tax savings, despite similar housing costs.

---

## Transportation

### With Car

| Expense | Monthly |
|---------|---------|
| Car payment | $300-600 |
| Insurance | $100-200 |
| Gas | $100-200 |
| Parking | $0-300 |
| Maintenance | $50-100 |
| **Total** | **$550-1,400** |

### Without Car

| Expense | Monthly |
|---------|---------|
| ORCA pass | $99 |
| Uber/Lyft (occasional) | $100-200 |
| Car share (Zipcar) | $50-100 |
| **Total** | **$250-400** |

---

## Food

### Groceries (Monthly, Single Person)

| Style | Cost |
|-------|------|
| Budget (Trader Joe's, cooking) | $300-400 |
| Average | $400-500 |
| Whole Foods shopper | $600-800 |

### Eating Out

| Meal Type | Cost Per Person |
|-----------|-----------------|
| Coffee | $4-7 |
| Fast casual lunch | $12-18 |
| Casual dinner | $20-35 |
| Nice dinner | $50-80 |
| Fine dining | $100-200+ |

### Monthly Food Budget

| Style | Cost |
|-------|------|
| Cook mostly, occasional dining | $500-700 |
| Mix of cooking and eating out | $800-1,000 |
| Eat out frequently | $1,200-1,800 |

---

## Utilities

| Utility | Monthly |
|---------|---------|
| Electricity | $50-100 |
| Gas (if applicable) | $30-60 |
| Water/sewer | $50-80 (often in rent) |
| Garbage | $40-60 (often in rent) |
| Internet | $60-100 |
| Phone | $50-100 |
| **Total** | **$200-400** |

---

## Healthcare

### With Employer Insurance
- Premium: $100-400/month (your share)
- Typical deductible: $500-2,000
- Copays: $20-50

### Without Employer
- ACA plans: $300-600/month
- Deductibles vary widely
- Washington Healthplanfinder for marketplace

---

## Entertainment

| Activity | Cost |
|----------|------|
| Movie ticket | $14-18 |
| Concert (mid-tier) | $50-150 |
| Seahawks game | $100-300 |
| Gym membership | $30-100/month |
| Skiing (day) | $100-150 |
| Museum entry | $15-25 |

### Free Activities
- Hiking (most trailheads free)
- Parks (all free)
- Beaches (free)
- Many museums (free days)
- Farmers markets (browsing)

---

## Monthly Budget Examples

### Young Professional (Single)

| Category | Budget |
|----------|--------|
| Rent (1BR Capitol Hill) | $2,000 |
| Utilities | $150 |
| Transit | $100 |
| Groceries | $400 |
| Eating out | $400 |
| Entertainment | $200 |
| Phone | $80 |
| Health insurance | $150 |
| Savings | $500 |
| **Total** | **$3,980** |

**Income needed:** $80K+ comfortable

### Couple (No Kids)

| Category | Budget |
|----------|--------|
| Rent (2BR) | $2,800 |
| Utilities | $200 |
| Car | $600 |
| Groceries | $600 |
| Eating out | $500 |
| Entertainment | $300 |
| Phones | $150 |
| Health insurance | $300 |
| Savings | $1,000 |
| **Total** | **$6,450** |

**Income needed:** $140K+ household

### Family (2 Kids)

| Category | Budget |
|----------|--------|
| Rent/mortgage (3BR) | $4,000 |
| Utilities | $300 |
| Two cars | $1,000 |
| Groceries | $1,000 |
| Eating out | $400 |
| Childcare | $3,000 |
| Activities | $300 |
| Health insurance | $500 |
| Savings | $1,000 |
| **Total** | **$11,500** |

**Income needed:** $200K+ household

---

## Salary Expectations

### Tech (Total Compensation)

| Level | Range |
|-------|-------|
| New grad | $150-180K |
| Mid-level (L4) | $200-300K |
| Senior (L5) | $300-400K |
| Staff (L6) | $400-600K |
| Principal+ | $600K+ |

### Other Industries

| Role | Range |
|------|-------|
| Nurse | $80-120K |
| Teacher | $60-90K |
| Marketing Manager | $90-140K |
| Finance | $100-200K |
| Legal | $150-300K |

---

## Money-Saving Tips

1. **Skip the car** in urban Seattle
2. **Roommates** still common for young professionals
3. **Beacon Hill, Columbia City** cheaper than Capitol Hill
4. **Happy hour** dining
5. **Outdoor activities** (mostly free)
6. **Cook more** (eating out expensive)
7. **Employer transit benefits** (many offer)
8. **Compare neighborhoods** carefully
