# Weather and Climate - Seattle

## The Myth vs Reality

| Myth | Reality |
|------|---------|
| "Rains all the time" | 37 inches/year (less than NYC, Miami, Atlanta) |
| "Need umbrella always" | Light drizzle — locals rarely use umbrellas |
| "Always cold" | Mild — rarely below freezing, rarely above 85F |
| "Always cloudy" | TRUE — 200+ overcast days per year |
| "No summer" | FALSE — Jul-Sep is gorgeous |

**The grey is real.** The rain reputation is exaggerated.

---

## Monthly Breakdown

| Month | Avg High | Avg Low | Rain | Notes |
|-------|----------|---------|------|-------|
| Jan | 47F | 37F | 5.1" | Grey, dark |
| Feb | 50F | 38F | 3.6" | Still grey |
| Mar | 54F | 40F | 3.5" | Starting to improve |
| Apr | 59F | 43F | 2.6" | Spring arriving |
| May | 65F | 49F | 2.0" | Nice! |
| Jun | 70F | 53F | 1.5" | Getting good |
| Jul | 76F | 57F | 0.8" | Best month |
| Aug | 76F | 57F | 1.0" | Still great |
| Sep | 70F | 53F | 1.6" | Excellent |
| Oct | 60F | 47F | 3.2" | Turning grey |
| Nov | 51F | 40F | 5.4" | Grey begins |
| Dec | 46F | 36F | 5.2" | Dark, wet |

---

## Seasonal Reality

### Winter (November - February)
- **Grey, dark, drizzly**
- Sunrise: 8am, Sunset: 4:30pm (December)
- Rain is light but constant
- Snow rare (1-2 days/year usually)
- SAD (Seasonal Affective Disorder) is real

**Survival tips:**
- Light therapy lamp ($30-50, worth it)
- Vitamin D supplements
- Indoor activities planned
- Escape trips to sunnier places
- Accept it and layer up

### Spring (March - May)
- **Improving but variable**
- Cherry blossoms late March (UW campus)
- Still rainy but more sun breaks
- Temperatures mild
- Great for tulip festival (April)

### Summer (June - September)
- **Glorious**
- Sunny, dry, 70-85F
- Everyone goes outside
- Mountains are accessible
- Book ahead for everything
- Best time to visit/move

**Summer reality:**
- Locals treasure every sunny day
- Outdoor events everywhere
- Traffic to mountains/beaches
- Best hiking season
- Ferries crowded

### Fall (September - October)
- **Beautiful transition**
- Often sunny into October
- Leaves change
- Good hiking weather
- Rain starts late October

---

## Microclimates

Seattle area has distinct microclimates:

| Area | Tendency |
|------|----------|
| Downtown | Slightly warmer, wind tunnels |
| Capitol Hill | Similar to downtown |
| Ballard | Slightly cooler (near water) |
| West Seattle | More fog |
| Eastside | Slightly warmer, more sun |
| Mountains | Much colder, more rain |

**Rule:** Eastside often clearer than Seattle, especially in fall/spring.

---

## What to Wear

### Year-Round
- **Layers** — Essential
- **Waterproof shell** — Not umbrella
- **Comfortable walking shoes**

### By Season

**Winter:**
- Rain jacket (not umbrella)
- Layers (fleece, sweater)
- Waterproof shoes/boots
- Hat and gloves (occasionally)

**Summer:**
- Light layers (mornings cool)
- Sunglasses
- Sunscreen (UV strong)
- Shorts and t-shirts by afternoon

---

## Dealing with the Grey

### Seasonal Affective Disorder (SAD)
Very common in Seattle. Symptoms:
- Low energy
- Sleeping more
- Mood changes
- Carb cravings

### What Helps
1. **Light therapy lamp** — 10,000 lux, 30 min morning
2. **Vitamin D** — Most Seattleites are deficient
3. **Exercise** — Even indoors
4. **Go outside anyway** — Daylight helps even if cloudy
5. **Escape trips** — Weekend in California
6. **Embrace hygge** — Cozy indoor activities

### When Sunny
- **Drop everything** — Go outside
- Sunny days are precious
- Check forecast obsessively
- Be flexible with plans

---

## Weather Apps

| App | Best For |
|-----|----------|
| Dark Sky (defunct) | Was the best |
| Apple Weather | Good hourly |
| Weather Underground | Hyperlocal |
| Windy | Mountain/outdoor planning |

---

## Outdoor Activity Windows

| Activity | Best Months |
|----------|-------------|
| Hiking (lowland) | Year-round (trails muddy winter) |
| Hiking (alpine) | July-September |
| Skiing | December-April |
| Kayaking | May-September |
| Beach days | July-August |
| Running | Year-round |

---

## Extreme Weather Events

### Heat Waves
- Rare but happening more
- 2021: Hit 108F (extreme outlier)
- AC not standard in older buildings
- Cooling centers open

### Snow
- 1-3 times per year usually
- City shuts down (not equipped)
- Hills become impossible
- Work from home expected

### Wildfire Smoke
- Not local but drifts from Eastern WA
- August-September worst
- Check AQI (air quality index)
- Stay inside on bad days
- N95 masks help

### Wind Storms
- Occasional fall/winter
- Power outages possible
- Trees down (old growth areas)
- Generally not dangerous

---

## Climate Change Impact

- Summers getting hotter
- Heat waves more common
- Wildfire smoke worse
- Still grey in winter
- Snow less frequent
- Overall: becoming more extreme
