# SearXNG API Reference

## Overview

SearXNG is a privacy-respecting metasearch engine that aggregates results from 250+ search engines while protecting user privacy.

**Default URL:** `http://127.0.0.1:8080` (customizable via `SEARXNG_URL` environment variable)

**Public instances:** Available at https://searx.space (list of public SearXNG servers)

### Privacy Protection

SearXNG protects users through:
- **Randomized browser fingerprints** per query (fake version, OS, resolution, language)
- **IP masking** (search engines see SearXNG IP, not user IP)
- **No cookie forwarding** to external engines
- **No referrer information** to target websites
- **Optional Tor/Proxy routing** for additional anonymity

This prevents search engines from building user profiles or tracking behavior across searches.

## Using the Search Script

The bundled `scripts/search.py` handles HTML parsing and returns clean JSON results.

### Basic Usage

```bash
python3 scripts/search.py "query"
```

### Options

```bash
--categories CATS    # Categories to search (general, images, news, videos, music, files, science)
--engines ENGS       # Specific engines to use (comma-separated)
--lang LANG          # Language code (en, de, fr, etc.)
--num N              # Number of results to return (default: 10)
--bang BANG          # DuckDuckGo-style bang for direct engine search (!g, !w, !yt, etc.)
```

### Environment Variables

```bash
SEARXNG_URL          # SearXNG instance URL (default: http://127.0.0.1:8080)
```

### Examples

```bash
# Basic search
python3 scripts/search.py "OpenClaw AI"

# News search
python3 scripts/search.py "latest tech news" --categories news --num 5

# German search
python3 scripts/search.py "Python Tutorial" --lang de

# Multiple categories
python3 scripts/search.py "machine learning" --categories general,science

# Bang search (Wikipedia)
python3 scripts/search.py "Albert Einstein" --bang w

# Bang search (YouTube)
python3 scripts/search.py "python tutorial" --bang yt

# Bang search (GitHub)
python3 scripts/search.py "openclaw" --bang gh

# Use custom SearXNG instance
SEARXNG_URL=https://searx.example.com python3 scripts/search.py "query"
```

## Output Format

```json
{
  "query": "OpenClaw",
  "number_of_results": 3,
  "results": [
    {
      "url": "https://example.com",
      "title": "Page Title",
      "content": "Snippet of page content..."
    }
  ]
}
```

## Categories

- `general` - Web search (default)
- `news` - News articles
- `images` - Image search
- `videos` - Video search
- `music` - Music search
- `files` - File search
- `science` - Scientific papers
- `social media` - Social media posts

## Bangs

Bangs are shortcuts to search directly on specific engines (DuckDuckGo-style). Prepend `!` to the bang code.

**Popular bangs:**
- `!g` - Google
- `!w` - Wikipedia
- `!yt` - YouTube
- `!gh` - GitHub
- `!r` - Reddit
- `!a` - Amazon
- `!so` - Stack Overflow
- `!ddg` - DuckDuckGo

**Usage:**
```bash
python3 scripts/search.py "query" --bang w
# or
python3 scripts/search.py "!w query"  # Bang in query works too
```

Full list of bangs: https://duckduckgo.com/bang

## Error Handling

Errors are returned in JSON format:

```json
{
  "error": "Connection error: ...",
  "query": "..."
}
```

## The Problem with Traditional Search

**Search market in Germany (and globally):**
- 90% Google
- 5% Bing
- 5% Others

**Privacy issues:**
- Browser fingerprints (version, OS, screen size, language, fonts, etc.)
- Combined into unique user IDs
- Tracked across searches and websites
- Used for profiling and ad targeting

**What Google openly collects:**
- "Terms you search for"
- "Videos you watch"
- "Content and ads you view and interact with"

## vs. Brave Search API

**SearXNG advantages:**
- ✅ Self-hosted (no external API calls)
- ✅ Privacy-respecting (randomized fingerprints, IP masking)
- ✅ Aggregates 250+ engines simultaneously
- ✅ No API keys required
- ✅ Free (no rate limits)
- ✅ Ad-free results
- ✅ Optional Tor/Proxy routing

**Brave API advantages:**
- ✅ JSON API (cleaner)
- ✅ More structured data
- ✅ Faster response times

**When to use SearXNG:**
- Privacy-sensitive searches
- High-volume searches (no API limits)
- When self-hosted infrastructure is available
- When ad-free results are important

**When to use Brave API:**
- When speed is critical
- When structured data is important
- When external API calls are acceptable
