# SearXNG Bangs Skill

Privacy-first web search with DuckDuckGo-style bangs for OpenClaw.

## Features

- 🛡️ **Privacy-First** - Randomized browser fingerprints, IP masking, no tracking
- 🎯 **Bangs Support** - DuckDuckGo-style shortcuts (!w, !yt, !gh, !r, etc.)
- 📊 **250+ Engines** - Aggregates results from multiple search engines
- 🗂️ **Multi-Category** - Search general, news, images, videos, science
- 🚫 **Ad-Free** - Pure search results without advertising
- 🔓 **No API Keys** - Free and unlimited

## Quick Start

1. **Install SearXNG**
   ```bash
   docker run -d -p 8080:8080 searxng/searxng
   ```

2. **Install Skill**
   ```bash
   # Copy to OpenClaw skills directory
   cp -r searxng-bangs /app/skills/
   ```

3. **Configure** (if not using default localhost:8080)
   ```bash
   export SEARXNG_URL=http://your-instance:port
   ```

4. **Use**
   - "Search the web for OpenClaw"
   - "Find Python tutorials on Wikipedia" (uses `!w` bang)
   - "Search GitHub for openclaw" (uses `!gh` bang)
   - "What's the latest news on AI?"

## Examples

```bash
# Basic search
python3 scripts/search.py "OpenClaw AI"

# Bang search (Wikipedia)
python3 scripts/search.py "Albert Einstein" --bang w

# News search
python3 scripts/search.py "tech news" --categories news

# German search
python3 scripts/search.py "Python Tutorial" --lang de
```

## Why SearXNG?

### The Privacy Problem

In Germany, 90% of search traffic goes through Google, 5% through Bing. These services track users extensively using browser fingerprints – a unique combination of browser version, OS, screen resolution, language preferences, and more.

**What SearXNG does differently:**
- 🎭 **Randomized Fingerprints** - Generates a random browser profile for each query
- 🚫 **No Cookies** - Never sends cookies to external search engines
- 🔒 **IP Masking** - Uses SearXNG instance IP, not user IP
- 📊 **Result Aggregation** - Queries 250+ search engines simultaneously
- 🧹 **No Ads** - Pure results without advertising ballast

### Self-Hosting Benefits

When you run your own SearXNG instance:
- ✅ Complete control over your data
- ✅ Shared household anonymity (multiple users = more privacy)
- ✅ No rate limits or API restrictions
- ✅ Optional Tor/Proxy routing for extra anonymity

### vs. Brave Search API

- No API keys or rate limits
- Self-hosted (complete privacy)
- Aggregates multiple engines (Google, Bing, DDG, Qwant, etc.)
- DuckDuckGo-style bangs

### vs. Google Directly

- Privacy-respecting (no tracking, no profiling)
- No API restrictions
- Open source
- Ad-free results

## Documentation

- **SKILL.md** - Workflows and usage patterns
- **references/api.md** - Complete API reference, bangs list
- **INSTALL.md** - Installation and configuration guide

## Requirements

- Python 3.6+
- SearXNG instance (self-hosted or public)
- No additional dependencies (uses stdlib only)

## Using a Different Instance

If your SearXNG runs on a different URL:

```bash
export SEARXNG_URL=http://your-instance:port
```

Public instances are available at https://searx.space if you prefer not to self-host.

## Contributing

Suggestions and improvements welcome! This skill was built for the OpenClaw community.

## License

Public domain / CC0 - Use freely!

---

**Built for OpenClaw** | https://openclaw.ai
