# SearXNG Bangs Skill Installation

## Prerequisites

You need either:
1. **Self-hosted SearXNG** instance (recommended for privacy & anonymity)
2. **Public SearXNG** instance (see https://searx.space for list)

### Why Self-Host?

**Privacy benefits:**
- Complete control over your search data
- No need to trust external instance operators
- Shared household anonymity (multiple users = harder to profile individuals)
- Optional Tor/Proxy routing for additional anonymity

**Installation time:** ~5-10 minutes with Docker

### Quick Docker Setup

If you don't have SearXNG yet:

**Simple (one-liner):**
```bash
docker run -d -p 8080:8080 --name searxng searxng/searxng
```

**Persistent config (recommended):**
```bash
mkdir -p ~/docker/searxng/{config,data}
cd ~/docker/searxng
nano docker-compose.yml
```

**docker-compose.yml:**
```yaml
services:
  searxng:
    image: searxng/searxng:latest
    container_name: searxng
    restart: unless-stopped
    ports:
      - "8080:8080"
    volumes:
      - ./config:/etc/searxng
      - ./data:/var/cache/searxng
```

Then run:
```bash
docker compose up -d
```

SearXNG is now available at `http://localhost:8080`

**More details:** https://docs.searxng.org/admin/installation.html

## Installation

Copy this skill directory to your OpenClaw skills folder:

```bash
# On the host:
sudo cp -r /path/to/searxng-bangs /app/skills/

# Or if OpenClaw is running in Docker:
docker cp searxng-bangs/ <container-name>:/app/skills/
```

## Verify Installation

After copying, restart OpenClaw or reload skills. The skill should appear in the available skills list.

Test the skill by asking:
- "Search the web for OpenClaw"
- "Find information about Python tutorials"
- "What's the latest news on AI?"

## Configuration

The skill defaults to `http://127.0.0.1:8080`.

### Option 1: Environment Variable (Recommended)

Set `SEARXNG_URL` in your OpenClaw environment:

```bash
export SEARXNG_URL=http://172.20.0.1:8086  # Docker gateway
# or
export SEARXNG_URL=https://searx.be        # Public instance
```

Add to OpenClaw config or `.bashrc` for persistence.

### Option 2: Edit Script

Alternatively, edit `scripts/search.py` and change the default:

```python
SEARXNG_URL = os.environ.get('SEARXNG_URL', 'http://YOUR_URL_HERE')
```

### Alternative: Public Instance

If you prefer not to self-host, you can use a public SearXNG instance from https://searx.space:

```bash
export SEARXNG_URL=https://public-instance-url
```

**Note:** Self-hosting is recommended for privacy and reliability. Public instances may have rate limits.

## Testing

Test the search script directly:

```bash
cd /app/skills/searxng-bangs
python3 scripts/search.py "test query" --num 3
```

Expected output: JSON with search results.

**Test with bangs (key feature!):**

```bash
python3 scripts/search.py "OpenClaw" --bang w  # Wikipedia
python3 scripts/search.py "cat videos" --bang yt  # YouTube
python3 scripts/search.py "python package" --bang gh  # GitHub
python3 scripts/search.py "laptop 2026" --bang r  # Reddit
```

## Advanced Configuration

### Enable/Disable Search Engines

Edit `~/docker/searxng/config/settings.yml` to control which engines are available:

**Enable an engine globally:**
```yaml
- name: qwant
  engine: qwant
  shortcut: qw
  disabled: false  # Change true to false
```

**Disable/hide an engine:**
```yaml
# - name: google
#   engine: google
#   shortcut: go
```

After changes, restart SearXNG:
```bash
docker compose down && docker compose up -d
```

### Tor/Proxy Routing (Extra Anonymity)

Configure SearXNG to route all searches through Tor:

1. Edit `settings.yml`
2. Add Tor proxy configuration
3. All search queries will use Tor network

**Details:** See SearXNG docs for Tor/Proxy setup

### Available Engines

SearXNG supports 250+ search engines across categories:
- **General:** Google, Bing, DuckDuckGo, Qwant, Brave, Startpage
- **News:** Google News, Reuters, Tagesschau (German)
- **Images:** Google Images, Bing Images, Flickr
- **Videos:** YouTube, Vimeo, Dailymotion
- **Science:** Google Scholar, arXiv, PubMed
- **Files:** Internet Archive, GitHub
- **IT:** Stack Overflow, GitHub, Hugging Face

## Troubleshooting

**Connection errors:**
- Verify SearXNG is running: `curl http://127.0.0.1:8080/`
- Check Docker: `docker ps | grep searxng`
- Check Docker network if running in containers

**No results:**
- SearXNG may be slow on first search (engine startup)
- Try a simpler query
- Check SearXNG logs: `docker logs searxng`

**JSON API blocked:**
- Normal! The script uses HTML parsing instead
- JSON API is disabled by default for CSRF protection

**Slow searches:**
- Disable unused engines in `settings.yml`
- Reduce number of concurrent engines
- Consider self-hosting on faster hardware
