# SearXNG Bangs - Privacy-First Search with Shortcuts

**Tagline:** Privacy-respecting web search with DuckDuckGo-style bangs support

## Why This Skill?

### The Problem
- 90% of search traffic goes through Google (5% Bing)
- Search engines track users via browser fingerprints (OS, version, screen size, language, fonts)
- Personal data is collected, profiled, and used for ad targeting

### The Solution: SearXNG
This skill uses **SearXNG**, a privacy-respecting metasearch engine that:
- 🎭 **Randomizes browser fingerprints** with each query
- 🔒 **Masks your IP address** (search engines see SearXNG's IP, not yours)
- 🚫 **Blocks cookies and referrers** from reaching search engines
- 📊 **Aggregates 250+ search engines** simultaneously
- 🧹 **Delivers ad-free results**

### Unique Feature: Bangs Support 🎯

Search directly on specific engines with DuckDuckGo-style shortcuts:
- `!w` - Wikipedia
- `!yt` - YouTube
- `!gh` - GitHub
- `!r` - Reddit
- `!so` - Stack Overflow
- `!a` - Amazon
- ...and many more

**Example:** "Search for Python tutorial on YouTube" → uses `!yt` bang for direct YouTube search

## Key Features

✅ **Privacy Protection**
- Randomized browser fingerprints per query
- IP address masking
- No cookie/referrer forwarding
- Based on research from heise.de (German tech publication)

✅ **Bangs for Direct Engine Search**
- DuckDuckGo-style shortcuts
- More granular than categories
- Full bang list in documentation

✅ **250+ Search Engines**
- Web: Google, Bing, DuckDuckGo, Qwant, Brave, Startpage
- News: Google News, Reuters, Tagesschau
- Videos: YouTube, Vimeo, Dailymotion
- Science: Google Scholar, arXiv, PubMed
- And many more

✅ **Multi-Category Search**
- General, News, Images, Videos, Music, Files, Science

✅ **Clean JSON Output**
- Easy to parse and present
- Title, URL, content snippet

✅ **No API Keys Required**
- Free and unlimited searches
- No rate limits

## Requirements

- Python 3.6+ (stdlib only, no dependencies)
- SearXNG instance (self-hosted or public)

## Installation

1. Install SearXNG:
   ```bash
   docker run -d -p 8080:8080 searxng/searxng
   ```

2. Install skill:
   ```bash
   cp -r searxng-bangs /app/skills/
   ```

3. Configure (optional):
   ```bash
   export SEARXNG_URL=http://your-instance:port
   ```

## Usage Examples

```bash
# Basic search
python3 scripts/search.py "OpenClaw AI"

# Wikipedia bang
python3 scripts/search.py "Albert Einstein" --bang w

# YouTube bang
python3 scripts/search.py "Python tutorial" --bang yt

# GitHub bang
python3 scripts/search.py "openclaw" --bang gh

# News category
python3 scripts/search.py "tech news" --categories news

# German search
python3 scripts/search.py "Python Tutorial" --lang de
```

## Documentation

- **SKILL.md** - Agent instructions and workflows
- **references/api.md** - Complete API reference with bang list
- **INSTALL.md** - Installation guide with Docker setup

## Privacy Benefits

**Self-hosting SearXNG provides:**
- Complete control over search data
- Shared household anonymity (multiple users = harder to profile)
- Optional Tor/Proxy routing for additional anonymity
- No trust required in external instance operators

## Credits

Based on privacy research from heise.de article: "Websuche ohne US-Datenkraken: So hosten Sie Ihren eigenen Suchdienst per Raspi"

## License

Public domain / CC0 - Use freely!

---

**Built for OpenClaw** | Privacy-first search with shortcuts
