# Scryfall Search Syntax Reference

## Table of Contents
1. [Card Names](#card-names)
2. [Colors and Color Identity](#colors-and-color-identity)
3. [Card Types](#card-types)
4. [Oracle Text](#oracle-text)
5. [Mana Costs and CMC](#mana-costs-and-cmc)
6. [Power and Toughness](#power-and-toughness)
7. [Rarity](#rarity)
8. [Sets and Blocks](#sets-and-blocks)
9. [Format Legality](#format-legality)
10. [Prices](#prices)
11. [Comparisons and Operators](#comparisons-and-operators)

## Card Names

| Syntax | Description | Example |
|--------|-------------|---------|
| `name` or `!name` | Cards containing word | `lightning` |
| `!"exact name"` | Exact name match | `!"Lightning Bolt"` |

## Colors and Color Identity

| Syntax | Description | Example |
|--------|-------------|---------|
| `c:` or `color:` | Card color | `c:red`, `c:uw` |
| `id:` or `identity:` | Color identity | `id:golgari` |
| `c>=` `c<=` `c=` | Color comparisons | `c>=rg` |
| `c:m` or `c:multicolor` | Multicolored cards | `c:m` |
| `c:c` or `c:colorless` | Colorless cards | `c:c` |

**Color shortcuts:** w=white, u=blue, b=black, r=red, g=green, c=colorless

**Guild/clan names:** azorius, dimir, rakdos, gruul, selesnya, orzhov, izzet, golgari, boros, simic, esper, grixis, jund, naya, bant, abzan, jeskai, sultai, mardu, temur

## Card Types

| Syntax | Description | Example |
|--------|-------------|---------|
| `t:` or `type:` | Card type | `t:creature`, `t:instant` |
| `t:legendary` | Legendary cards | `t:legendary t:creature` |

Supports: creature, instant, sorcery, artifact, enchantment, land, planeswalker, battle, tribal, and all subtypes (goblin, elf, equipment, aura, etc.)

## Oracle Text

| Syntax | Description | Example |
|--------|-------------|---------|
| `o:` or `oracle:` | Text contains | `o:flying` |
| `o:"exact phrase"` | Exact phrase | `o:"draw a card"` |
| `fo:` | Full oracle (all faces) | `fo:transform` |

## Mana Costs and CMC

| Syntax | Description | Example |
|--------|-------------|---------|
| `m:` or `mana:` | Mana cost contains | `m:2ww` |
| `m:` with symbols | Hybrid, phyrexian | `m:{w/u}`, `m:{g/p}` |
| `cmc:` or `mv:` | Mana value | `cmc=3`, `cmc>=5` |

## Power and Toughness

| Syntax | Description | Example |
|--------|-------------|---------|
| `pow:` or `power:` | Power | `pow=3`, `pow>=5` |
| `tou:` or `toughness:` | Toughness | `tou<=2` |
| `pt:` | Combined P/T | `pt=3/3` |
| `loy:` | Loyalty | `loy>=4` |

## Rarity

| Syntax | Description | Example |
|--------|-------------|---------|
| `r:` or `rarity:` | Rarity | `r:mythic` |

Values: common, uncommon, rare, mythic, special, bonus

## Sets and Blocks

| Syntax | Description | Example |
|--------|-------------|---------|
| `e:` or `set:` | Set code | `e:dom`, `e:neo` |
| `b:` or `block:` | Block | `b:zendikar` |
| `st:` | Set type | `st:commander` |
| `in:` | Printed in set | `in:lea` |
| `is:reprint` | Is a reprint | `is:reprint` |
| `is:unique` | Only one printing | `is:unique` |

## Format Legality

| Syntax | Description | Example |
|--------|-------------|---------|
| `f:` or `format:` | Legal in format | `f:standard` |
| `banned:` | Banned in format | `banned:modern` |
| `restricted:` | Restricted in format | `restricted:vintage` |

Formats: standard, pioneer, modern, legacy, vintage, pauper, commander, oathbreaker, brawl, historic, alchemy, penny

## Prices

| Syntax | Description | Example |
|--------|-------------|---------|
| `usd:` | USD price | `usd>=10`, `usd<1` |
| `eur:` | EUR price | `eur<=5` |
| `tix:` | MTGO tix price | `tix>2` |

## Comparisons and Operators

| Operator | Meaning |
|----------|---------|
| `=` | Equal to |
| `!=` | Not equal to |
| `<` | Less than |
| `>` | Greater than |
| `<=` | Less than or equal |
| `>=` | Greater than or equal |
| `:` | Contains/includes |

**Boolean operators:**
- `AND` or space: Both conditions (default)
- `OR`: Either condition
- `-` or `NOT`: Exclude
- `()`: Grouping

**Examples:**
```
t:creature c:red pow>=4         # Red creatures with 4+ power
t:instant OR t:sorcery f:modern # Modern legal instants/sorceries
-t:creature c:green             # Green non-creatures
(t:goblin OR t:elf) cmc<=2      # Cheap goblins or elves
```

## Special Filters

| Syntax | Description |
|--------|-------------|
| `is:commander` | Can be commander |
| `is:spell` | Non-land cards |
| `is:permanent` | Permanent cards |
| `is:historic` | Legendary, artifact, or saga |
| `is:vanilla` | No rules text |
| `is:modal` | Modal cards |
| `is:split` | Split cards |
| `is:flip` | Flip cards |
| `is:transform` | Transform cards |
| `is:meld` | Meld cards |
| `is:leveler` | Level up cards |
| `has:watermark` | Has watermark |
| `new:art` | New art in set |
| `new:flavor` | New flavor text |
