# Screenshot Text Style

## Headline Principles

### Structure
- **Short:** 2-5 words per headline
- **Benefit-focused:** What user GETS, not what app DOES
- **Action verbs:** Start with action when possible

### Examples by Tone

**Punchy:**
- "Track effortlessly."
- "Never forget."
- "Inbox zero. Finally."

**Descriptive:**
- "See your progress at a glance"
- "Smart reminders that actually work"
- "Every receipt, organized"

**Minimal:**
- "Simple."
- "Focus."
- "Track. Plan. Done."

---

## Text Placement

### Positions
- **Top third:** Headline above screenshot
- **Bottom third:** Headline below screenshot  
- **Overlay:** Text on top of screenshot (needs contrast)

### Safe Zones
Never place text:
- Within 44px of top edge (status bar)
- Within 34px of bottom (home indicator)
- In corners (rounded display clips)

### Readability at Thumbnail Size
Test: Can you read the headline when screenshot is 150px wide?
- If no → increase font size
- If no → reduce word count
- If still no → simplify message

---

## Typography

### Font Pairing
- **Headline:** Bold sans-serif (SF Pro Display, Inter, Poppins)
- **Subheadline:** Regular weight, smaller size
- **Avoid:** More than 2 fonts per screenshot set

### Minimum Sizes
- Headlines: 60px minimum (for thumbnail readability)
- Subheadlines: 36px minimum
- Captions: 24px minimum (optional, often unnecessary)

### Contrast Requirements
- Light text on dark: Use white or very light
- Dark text on light: Use black or very dark
- Never: Gray text, low contrast combinations

---

## Per-Screenshot Structure

### Screenshot 1 (Hero)
- Strongest value proposition
- Most polished visual
- Often: "What is this app?"

### Screenshots 2-4 (Features)
- One key feature per screenshot
- Show the feature in action
- Connect to user benefit

### Screenshots 5-6 (Proof/Polish)
- Social proof, reviews, awards
- Unique differentiators
- "Why us vs competitors"

---

## Localization Notes

When translating:
- **German:** Tends to be 30% longer — may need smaller font
- **Japanese/Chinese:** May need different line height
- **RTL (Arabic/Hebrew):** Mirror layout AND text direction
- **Cultural:** Some imagery/colors have different meanings

Use native speaker review when possible. Machine translation is starting point only.
