# Visual Templates

## Template Categories

### By App Type

| Category | Background Style | Device Frame | Text Position |
|----------|------------------|--------------|---------------|
| Productivity | Clean gradient | Modern iPhone | Top |
| Finance | Dark, minimal | Frameless | Bottom |
| Health/Fitness | Vibrant gradient | Floating angle | Top |
| Social | Colorful, playful | With frame | Overlay |
| Utilities | Solid or subtle | Frameless | Top or none |
| Games | Dynamic, themed | None (full bleed) | Integrated |
| Kids | Bright, illustrated | Fun frame | Large text |

---

## Background Styles

### Gradient Types
```
Linear: Top-to-bottom, brand primary → darker
Radial: Center light, edges dark
Mesh: Multi-color organic gradients (trending)
```

### Color Extraction
1. Get dominant color from app icon
2. Create complementary or analogous palette
3. Light version = pastel/tinted white
4. Dark version = deep/rich tones

### Patterns
- **Subtle:** Noise texture, light geometric
- **Bold:** Abstract shapes, brand patterns
- **Photo:** Blurred app screenshot as background

---

## Device Frame Styles

### With Frame
- Real device mockup (iPhone 15 Pro, Pixel 8)
- Shows device as object
- Good for: premium apps, showcasing hardware integration

### Frameless
- Just the screen, rounded corners
- Clean, modern look
- Good for: productivity, utilities, minimal brands

### Floating Angle
- Device tilted 5-15 degrees
- Drop shadow for depth
- Good for: fitness, lifestyle, dynamic apps

### Full Bleed
- Screenshot fills entire image
- No visible device
- Good for: games, immersive experiences

---

## Layout Templates

### Centered Portrait
```
┌─────────────────┐
│                 │
│    HEADLINE     │
│                 │
│   ┌─────────┐   │
│   │         │   │
│   │  DEVICE │   │
│   │         │   │
│   └─────────┘   │
│                 │
└─────────────────┘
```

### Bottom Text
```
┌─────────────────┐
│   ┌─────────┐   │
│   │         │   │
│   │  DEVICE │   │
│   │         │   │
│   └─────────┘   │
│                 │
│    HEADLINE     │
│    subtext      │
└─────────────────┘
```

### Split Feature
```
┌─────────────────┐
│  HEADLINE       │
│                 │
│ ┌─────┐ ┌─────┐ │
│ │ OLD │ │ NEW │ │
│ └─────┘ └─────┘ │
│  Before   After │
└─────────────────┘
```

### Multi-Screen
```
┌─────────────────┐
│    HEADLINE     │
│                 │
│ ┌───┐ ┌───┐ ┌───┐│
│ │ 1 │ │ 2 │ │ 3 ││
│ └───┘ └───┘ └───┘│
│                 │
└─────────────────┘
```

---

## What Converts

Based on industry patterns:
1. **Show the app, not just talk about it** — real UI beats abstract
2. **One message per screenshot** — don't cram features
3. **Social proof on later screenshots** — ratings, reviews
4. **Consistent visual story** — feels like one brand
5. **Hero screenshot = make or break** — spend extra time here

## Anti-Patterns

Avoid:
- Stock photo backgrounds (looks cheap)
- Too much text (people don't read)
- Inconsistent styles between screenshots
- Outdated device frames (iPhone X in 2026)
- Competitor mentions (against store policies)
