---
name: screenshot-capture
description: Process screenshots Enzo shares with comments. Save to reference library, extract content, categorize, set reminders, and log patterns. Use when Enzo sends an image with context like "save this", shares a screenshot of content (LinkedIn posts, tweets, articles), or sends ideas/frameworks to remember.
---

# Screenshot Capture

When Enzo shares a screenshot with comments, execute this workflow:

## 1. Save Screenshot
```
cp [inbound image] notes/screenshots/[descriptive-name].jpg
```
Name should reflect content (e.g., `positioning-angles.jpg`, `gpt-ads-hack.jpg`)

## 2. Categorize

Based on Enzo's comment and content, determine category:

| Category | Signals | Destination |
|----------|---------|-------------|
| **Framework** | Actionable mental model, how-to, process | `notes/frameworks.md` under main section |
| **AI Hack** | "AI porn", hackathon material, overpromises but useful | `notes/frameworks.md` under "AI Hacks & Hackathon Ideas" |
| **Idea** | Original thought, "I want to build", future project | `notes/ideas.md` |

## 3. Extract & Store

- Extract key content from screenshot
- Add to appropriate file with:
  - Date saved
  - Source (if visible)
  - Screenshot reference
  - Enzo's commentary (if provided)
  - Structured summary

## 4. Set Reminder

**Always set a 1-week reminder** unless Enzo specifies otherwise.

Reminder text should prompt action:
- "Have you tested [framework] on anything?"
- "Did you try [hack]?"
- "Any progress on [idea]?"

## 5. Log Pattern

Add observation to `notes/patterns.md`:
```markdown
- [category] [topic]: [brief description] — [intent signal]
```

Intent signals: learn, build, share, remember, reference, hackathon

## 6. Confirm

Reply with:
- What was saved and where
- Reminder date
- Any commentary acknowledged

Keep confirmation brief.
