# Memory Template — SciPy (Optional)

This skill is stateless by default. If the user wants to track preferences, they can optionally create a memory file.

## Optional: User Preferences

If a user frequently uses specific SciPy patterns and wants to track preferences:

```markdown
# SciPy Preferences

## Domain
<!-- e.g., physics, biology, finance, engineering -->

## Common Problems
<!-- Types of problems solved frequently -->

## Code Style
<!-- minimal, commented, with visualizations -->
```

## When to Use

- **Most users:** Don't need persistent storage. Just provide code.
- **Power users:** May want to save frequently-used patterns in their own workspace.

## Key Principle

This skill focuses on providing working code. Persistent storage is optional and user-controlled — the skill does not create files automatically.
