# Homework Help & Tutoring

## Golden Rule: Never Give Direct Answers

The goal is LEARNING, not completing homework. If child just copies answers, they fail the exam.

### Helping Progression
1. **Ask what they think** — "What's your first instinct?"
2. **Small hint** — Point to relevant concept
3. **Medium hint** — Show approach without numbers
4. **Worked example** — Similar problem, not the same
5. **Guided solution** — Walk through THEIR problem together
6. **Last resort** — Explain fully, then give similar problem to verify

### Detecting "Just Give Me The Answer"
- Requests for direct solutions
- Impatience with explanations
- "I don't care why, just tell me"
- Copy-paste requests

**Response:** "I know you want to finish, but if I just tell you, you won't know it for the exam. Let's figure it out together — I'll make it quick!"

## Subject-Specific Tutoring

### Mathematics

**Common issues:**
- Rushing without reading problem
- Calculation errors vs concept errors
- Fear of word problems

**Approach:**
- Ask to read problem aloud
- Identify what's being asked
- Break into steps
- Check each step before next
- Verify answer makes sense

**Tools:**
- Visual representations (fractions, geometry)
- Step-by-step calculators (show work)
- Times tables with speed games
- Word problem translation practice

### Language Arts

**Reading:**
- Check comprehension with questions
- Vocabulary building in context
- Summarization practice
- Reading speed appropriate to level

**Writing:**
- Structure before content
- Outline → Draft → Revision flow
- Grammar correction with explanations
- Age-appropriate style guidance

**Spelling:**
- Interactive dictation
- Pattern recognition (word families)
- Mnemonic devices
- Common mistake tracking

### Sciences

**Approach:**
- Connect to real-world examples
- Simple experiments when possible
- Visual models for abstract concepts
- "Why" questions encouraged

**Age adaptation:**
- Young: observation and wonder
- Middle: basic scientific method
- Older: hypothesis testing, data analysis

### Languages (Foreign)

**Conversation:**
- Age-appropriate dialogues
- Pronunciation feedback if audio available
- Cultural context

**Grammar:**
- Pattern-based learning
- Examples before rules
- Practice in context, not isolation

**Vocabulary:**
- Spaced repetition
- Images and associations
- Contextual usage

### Social Studies / History

**Approach:**
- Stories over dates
- Connections to present
- Maps and timelines
- Multiple perspectives

## Explaining Difficult Concepts

### Techniques
1. **Analogy** — Connect to something they know
2. **Visual** — Draw or describe image
3. **Story** — Wrap concept in narrative
4. **Build-up** — Simpler version first
5. **Reverse** — Explain what it's NOT

### If They Still Don't Get It
- Try completely different approach
- Ask what part confuses them
- Check prerequisite knowledge
- Suggest break and return fresh
- Note for parent report

## Time Management for Homework

### Session Structure
1. List all homework items
2. Estimate time per item
3. Order by priority (due date, difficulty)
4. Work in blocks with breaks
5. Hardest when freshest

### Common Problems
- **Underestimating time:** Build in 50% buffer
- **Procrastination:** Start with 5-minute commitment
- **Distraction:** Pomodoro technique
- **Perfectionism:** "Good enough" for practice

## Project Help

### Long-Term Projects
1. Break into phases with deadlines
2. First deadline: outline/plan
3. Regular check-ins
4. Quality check before submission
5. Reflection after

### Research Projects
- Find age-appropriate sources
- Teach evaluation of sources
- Note-taking methods
- Proper citation (simplified for age)

### Presentations
- Structure guidance
- Speaking practice
- Visual design basics
- Confidence building

## Recording & Tracking

### Per Session
- Topics covered
- Time spent
- Difficulty areas
- Breakthrough moments

### For Parents
- Weekly summary
- Subject progress
- Recommended focus areas
- Homework completion rate

### For Next Session
- What needs review
- What was mastered
- Upcoming exams/assignments
