# Parent Dashboard & Controls

## Dashboard Overview

### Quick Glance (Per Child)
```
[Child Name] - Grade 5
├── This Week: 4h 30m studied
├── Subjects: Math ⚠️ | Language ✅ | Science ✅
├── Upcoming: Math exam in 5 days
└── Streak: 12 days
```

### Detailed View
- Time spent per subject
- Topics covered
- Mastery levels by subject
- Progress vs last week/month
- Alerts and recommendations

## What Parents Can See

### Always Visible
- Total study time
- Subjects worked on
- Progress metrics
- Exam dates and preparation status
- Difficulty areas (by topic, not conversation)

### Never Visible
- Exact conversation text
- Specific questions asked
- Emotional conversations
- Anything child marks as private

### Configurable
- Level of detail in reports
- Alert thresholds
- Notification frequency

## Parental Controls

### Time Limits
- Maximum minutes per day
- Maximum minutes per session
- Allowed hours (e.g., 17:00-20:00)
- Weekend vs weekday different
- Automatic session end

### Content Controls
- Subjects to focus on
- Topics to avoid
- Difficulty ceiling
- Language settings

### Help Levels
- How many hints before explanation
- Whether to show worked examples
- Strictness of "no direct answers"

## Reports

### Daily Summary (Optional)
- What was studied today
- How long
- Any difficulties
- Tomorrow's priorities

### Weekly Report (Recommended)
- Hours per subject
- Progress on each subject
- Mastery changes
- Areas needing attention
- Positive highlights
- Suggested actions

### Monthly Overview
- Trends over time
- Comparison with curriculum expectations
- Long-term patterns
- Recommendations

## Alerts

### Automatic Alerts
| Alert Type | When | Severity |
|------------|------|----------|
| Struggling | Same topic failed 3+ times | ⚠️ Medium |
| Behind schedule | Exam in 3 days, not ready | 🔴 High |
| Low engagement | No use in 5+ days | ⚠️ Medium |
| Safety concern | Mentions harm, bullying | 🔴 Critical |
| Goal achieved | Mastered a tough topic | ✅ Positive |

### Alert Settings
- Which alerts to receive
- How to receive (app, email, none)
- Threshold adjustments
- Quiet hours

## Multi-Child Management

### Separate Profiles
- Each child has own data
- Age-appropriate settings per child
- Individual reports
- Sibling comparison (optional, use carefully)

### Family View
- Overview of all children
- Combined schedule
- Shared resources

## Communication with Child

### Through the Agent
- Set goals together
- Celebrate achievements
- Encourage when struggling
- "Mom/Dad wants you to know..."

### Direct Suggestions
- How to help offline
- Topics to discuss at dinner
- Activities to reinforce learning
- When to back off

## Privacy Balance

### Building Trust
- Child knows what's shared
- No secret surveillance
- Age-appropriate transparency
- Conversation privacy respected

### When to Override
- Clear safety concerns
- Significant academic decline
- Child requests help
- Concerning patterns

### As Child Ages
- Gradually reduce visibility
- Increase autonomy
- Teen years: summary only
- Build toward independence

## Settings Management

### Per-Child Config
```markdown
# [Child Name] Settings

## Profile
- Age: 10
- Grade: 5th
- School system: Spain

## Limits
- Daily max: 45 min
- Session max: 25 min
- Hours: 17:00-20:00 weekdays, 10:00-12:00 weekends

## Subjects
- Focus: Math, English
- All others: available

## Help Level
- Hints before explanation: 3
- Show worked examples: yes
- Direct answers: never

## Reports
- Daily summary: no
- Weekly report: yes (Sunday)
- Alerts: all except positive
```

## Emergency Access

- Parent can always access in emergency
- Safety alerts bypass all privacy
- Clear audit trail of access
- Explain to child when accessed
