# Exams & Assessment

## Practice Test Generation

### From Topics
1. Parent or child inputs exam topics
2. Generate questions matching curriculum level
3. Mix question types (multiple choice, short answer, problems)
4. Include easier AND harder than expected
5. Provide answer key with explanations

### From Materials
1. Upload class notes, textbook photos, worksheets
2. Extract key concepts
3. Generate questions covering all topics
4. Weight by apparent importance
5. Flag any gaps in coverage

### Difficulty Levels
- **Easy:** Build confidence, verify basics
- **Medium:** Expected exam level
- **Hard:** Stretch challenges, prepare for surprises
- **Exam simulation:** Exact format, timed, no hints

## Exam Simulation

### Setup
1. Select subject and topics
2. Set time limit (match real exam)
3. Choose format (strict time vs flexible)
4. Disable hints and helps

### During
- Timer visible
- No feedback until end
- Flag questions for review
- Submit when done

### After
- Immediate score
- Breakdown by topic
- Each question reviewed with explanation
- Identify patterns in errors
- Comparison with previous attempts

## Tracking Mastery

### Per-Topic Assessment
After studying and practicing:
- Quiz on specific topic
- Track correct/incorrect
- Calculate mastery percentage
- Schedule review based on performance

### Mastery Levels
| Level | Score | Meaning |
|-------|-------|---------|
| Not started | - | No assessment yet |
| Learning | <50% | Needs more study |
| Developing | 50-69% | Partial understanding |
| Proficient | 70-84% | Good grasp |
| Mastered | 85%+ | Ready for exam |

### Decay Tracking
- Knowledge fades over time
- Schedule reviews before it's lost
- Weight recent performance higher
- Alert if mastery dropping

## Exam Preparation Plans

### Countdown Mode
When exam date is set:
1. Calculate days remaining
2. List all topics to cover
3. Assign topics to days
4. Reserve last 2-3 days for review
5. Include practice tests

### Daily Check-ins
- What to study today
- Estimated time needed
- Priority topics (low mastery first)
- Progress update at end

### Week Before Exam
- Light review only (no new material)
- Practice tests daily
- Focus on weak spots
- Sleep and rest emphasis
- Confidence building

## Different Exam Types

### Multiple Choice
- Practice elimination strategies
- Time per question guidance
- Review flagged questions
- Guessing strategies

### Essay/Written
- Outline before writing
- Time allocation practice
- Structure templates
- Self-review checklist

### Oral Exams
- Practice explaining concepts aloud
- Simulate question/answer
- Handle "I don't know" gracefully
- Confidence techniques

### Practical/Lab
- Procedure checklists
- Safety reminders
- Step-by-step practice
- Common mistakes to avoid

## Post-Exam

### After Results
- Review what went wrong
- Update mastery tracking
- Celebrate what went right
- Lessons for next time

### If Failed
- Analyze specific failures
- Identify if study or test-taking issue
- Create recovery plan
- Maintain motivation
- It's okay to fail — learn from it

### Building Test-Taking Skills
- Time management strategies
- Stress management techniques
- Reading questions carefully
- Checking work
- Handling difficult questions

## Grade-Specific Exams

### Elementary
- Low-pressure approach
- Focus on learning, not scores
- Celebrate effort
- Age-appropriate timing

### Middle School
- Introduction to test strategies
- Managing increased pressure
- Multiple subject coordination
- Study schedule management

### High School
- High-stakes exam prep (SAT, AP, IB, Selectividad)
- University entrance focus
- Advanced time management
- Stress resilience building
