# Curriculum Integration

## Supporting Any Country's System

### Curriculum Configuration
On setup, parent specifies:
- Country (Spain, USA, UK, Mexico, etc.)
- Region if relevant (state, province)
- School type (public, private, charter)
- Grade level
- Any special programs (IB, Montessori, etc.)

### Adaptation
- Use grade-appropriate vocabulary
- Match subject names to local terms
- Align with expected progression
- Respect cultural contexts

## Connecting to Real School

### Manual Integration
1. Parent enters upcoming topics
2. Parent uploads syllabus/schedule
3. Agent focuses on those topics
4. Alignment with homework

### Benefits
- Reinforces what school teaches
- Doesn't confuse with different approaches
- Prepares for school exams
- Complements, doesn't replace

## Subject Mapping

### Core Subjects (All Countries)
| Universal | Spain | USA | UK |
|-----------|-------|-----|-----|
| Math | Matemáticas | Math | Maths |
| Language | Lengua | ELA | English |
| Science | Ciencias | Science | Science |
| Social Studies | Conocimiento/Sociales | Social Studies | Geography/History |
| Foreign Language | Inglés | Spanish/French | MFL |

### Grade Mapping
| Age | Spain | USA | UK |
|-----|-------|-----|-----|
| 6 | 1° Primaria | 1st Grade | Year 2 |
| 10 | 5° Primaria | 5th Grade | Year 6 |
| 12 | 1° ESO | 7th Grade | Year 8 |
| 16 | 4° ESO | 10th Grade | Year 11 |
| 18 | 2° Bachillerato | 12th Grade | Year 13 |

## Homework Integration

### Daily Workflow
1. Child (or parent) enters today's homework
2. Agent organizes by subject
3. Help provided per assignment
4. Track completion
5. Review before submission

### Assignment Types
- Written exercises
- Reading assignments
- Research projects
- Practice problems
- Creative work
- Group project preparation

## Exam Calendar

### Tracking
- Parent enters exam dates
- Agent creates preparation plan
- Countdown and reminders
- Readiness assessment

### Types
- Class quizzes
- Unit tests
- Midterm/final exams
- Standardized tests (national, state)
- Entrance exams

## Using School Materials

### Uploading
- Photos of textbook pages
- Scanned worksheets
- Teacher handouts
- Class notes

### Processing
- Extract content
- Create study materials
- Generate practice problems
- Align explanations with school approach

## Working with Teachers

### For Parents
- Share progress reports (optional)
- Align on struggling areas
- Coordinate approach
- Note different explanations

### Consistency
- If teacher uses specific method, match it
- Don't contradict school teaching
- Supplement, don't replace
- Clarify if confused

## Homeschool Mode

### Full Curriculum
If replacing school entirely:
- Complete grade-level curriculum
- All subjects covered
- Progress tracking against standards
- Portfolio building
- Assessment documentation

### Standards Alignment
- Common Core (USA)
- National Curriculum (UK)
- LOMLOE (Spain)
- Regional requirements

## Summer & Breaks

### Maintain Learning
- Review mode during breaks
- Fun learning activities
- Prevent regression
- Light touch, not intense

### Catch-Up
- Address gaps from school year
- Prepare for next grade
- Summer projects
- Enrichment activities

## Special Programs

### Gifted
- Accelerated content
- Deeper exploration
- Challenge problems
- Don't hold back

### Learning Differences
- Extra patience
- Multiple explanations
- Accommodations
- Celebrate small wins
- Coordinate with specialists

### Second Language Learners
- Vocabulary support
- Concept explanation in native language
- Bridge to target language
- Cultural sensitivity

## Progress Documentation

### Records Kept
- Topics covered
- Time spent
- Mastery levels
- Assessments taken
- Areas of difficulty

### Uses
- Parent review
- Teacher sharing (optional)
- Homeschool documentation
- Transition planning
