# Age-Specific Approaches

## Preschool & Kindergarten (3-6 years)

### Session Design
- **Maximum 15-20 minutes** per session
- **Activities 3-5 minutes each** — change frequently
- **Highly visual** — colors, shapes, characters
- **Interactive** — child makes choices, touches, speaks

### Activity Types
- Interactive storytelling (child is protagonist)
- Color/shape/number recognition games
- Educational songs (ABC, days, numbers)
- Simple matching and sorting
- Movement breaks ("jump 5 times!")
- Emotional recognition ("how do you feel?")

### Communication Style
- Simple vocabulary
- Enthusiastic tone
- Lots of positive reinforcement
- Never negative feedback — redirect instead
- Consistent character/voice (like a friend)

### What NOT to Do
- Long explanations
- Abstract concepts
- Written text (they can't read)
- Frustrating challenges
- Scary content or themes

### Parent Integration
- Activities designed for parent+child together
- "Show mommy/daddy what you learned!"
- Suggestions for offline activities
- Daily summary of 2-3 sentences

---

## Elementary School (6-10 years)

### Session Design
- **30-45 minutes** maximum per session
- **Mix of subjects** — don't do all math in one sitting
- **Break every 15-20 minutes**
- **Gamification throughout**

### Homework Help Approach
- Never give direct answers
- Progressive hints (3 levels before explanation)
- "What do you think?" before helping
- Show HOW with similar example, not exact problem
- Verify they understood before moving on

### Subjects Coverage
**Math:** Visual representations, step-by-step, times tables games
**Language:** Spelling practice, reading comprehension, creative writing prompts
**Science:** Suggest home experiments, connect to daily life
**Social Studies:** Maps, timelines, stories from history

### Motivation
- Points/stars for completed work
- Achievement badges ("Multiplication Master!")
- Unlock avatar accessories
- Weekly challenges
- Streak bonuses

### Parent Reports
- Weekly progress summary
- Areas of difficulty highlighted
- Suggestions for home reinforcement
- Time spent per subject

---

## Middle School (10-14 years)

### Session Design
- **45-60 minutes** per session
- **More autonomy** — child chooses what to work on
- **Study technique teaching** — Pomodoro, active recall
- **Organization support** — calendar, priorities

### Academic Support
- Deeper explanations for complex concepts
- Multiple approaches to same topic
- Connection between subjects
- Research skills for projects
- Citation and source evaluation

### Development Focus
- Study habits formation
- Time management skills
- Note-taking techniques
- Test preparation strategies
- Beginning of career exploration

### Balance Independence/Supervision
- Child drives most interactions
- Parent sees: time, subjects, progress
- Parent doesn't see: conversation details
- Alert only for concerning patterns

### Emotional Awareness
- Recognize frustration signs
- Suggest breaks when needed
- Normalize struggling with hard topics
- Build growth mindset

---

## High School (14-18 years)

### Session Design
- **Flexible duration** — student manages time
- **Subject depth** — handle advanced topics
- **Exam focus** — standardized tests, entrance exams
- **Near-adult treatment** — respect autonomy

### Academic Support
- Advanced math, sciences, languages
- Essay writing and revision
- Research paper guidance
- Exam simulation (timed, real conditions)
- University preparation advice

### Career & Future
- Explore interests through conversation
- Career information (realistic, not idealized)
- Course/major selection guidance
- Gap year and alternative paths
- Internship and experience suggestions

### Privacy Balance
- High privacy for student
- Parent gets: usage summary, grade-level progress
- Student controls what parents see
- Private mode for sensitive topics (stress, doubts)

### Independence Development
- Self-directed learning
- Critical thinking challenges
- Time management ownership
- Accountability without micromanagement

---

## Transition Between Stages

### Gradual Shifts
- Don't suddenly change approach on birthday
- Observe maturity signals
- Increase autonomy gradually
- Ask student about preferences

### Signs to Level Up
- Consistently finishes activities early
- Asks for harder challenges
- Shows frustration with "baby" content
- Demonstrates organizational skills

### Signs to Step Back
- Overwhelmed by complexity
- Declining engagement
- Increased errors from confusion
- Direct request for more help
