# 更新日志 (CHANGELOG)

## [1.0.0] - 2026-02-28

### 🎉 首次发布

完整的学术文献智能工具包，包含 10 大核心功能。

### ✨ 新增功能

#### 基础功能 (6个)
- **文献检索**: 跨 arXiv、Semantic Scholar 和 Web 的多源检索
- **概念学习**: 生成结构化学习卡片，支持代码示例和相关论文
- **知识盲区检测**: 主动识别知识体系中的盲点
- **进展追踪**: 实时监控研究领域动态，自动生成报告
- **论文分析**: 深度论文分析，支持 quick/standard/deep 三种模式
- **知识图谱**: 可视化概念关系，支持 Mermaid 和 JSON 格式

#### 高级功能 (4个)
- **概念对比**: 对比两个概念的相似点、差异点和使用场景
- **论文对比**: 对比 2-N 篇论文的共同主题和差异
- **批判性分析**: 识别论文的优点、缺点、研究空白和改进建议
- **学习路径**: 查找从一个概念到另一个概念的最优学习路径

### 🔧 技术特性

- **多 AI 提供商支持**: 支持 15+ AI 提供商
  - 国际: OpenAI, Anthropic, Azure OpenAI, Groq, Together AI, Ollama
  - 国内: 通义千问, DeepSeek, 智谱 AI, MiniMax, Moonshot, 百川 AI, 零一万物, 豆包

- **速率限制处理**:
  - Semantic Scholar API 自动重试和延迟
  - 最小 1 秒请求间隔
  - 指数退避重试机制

- **多种输出格式**:
  - Markdown 报告（便于阅读和分享）
  - JSON 数据（便于程序化处理）
  - Mermaid 图表（便于可视化）

### 📚 文档

- **README.md**: 完整的项目文档和使用指南
- **ADVANCED_FEATURES.md**: 高级功能详细说明
- **TEST_RESULTS.md**: 全面的测试结果报告

### ✅ 测试覆盖

- ✅ 所有 10 个核心功能测试通过
- ✅ CLI 和编程 API 均可正常使用
- ✅ 支持文件输出和控制台输出
- ✅ 多 AI 提供商测试通过

### 🐛 已知问题

- Semantic Scholar API 有速率限制，建议使用 arXiv URL
- 需要配置 SERPER_API_KEY 以启用 web 搜索降级

### 📦 依赖

- Bun 1.3+
- TypeScript 5.0+
- z-ai-web-dev-sdk
- axios

---

## 未来计划

### v1.1.0 (计划中)
- [ ] 添加更多数据源支持（Google Scholar, PubMed）
- [ ] 支持批量论文分析
- [ ] 添加论文引用网络分析
- [ ] 支持自定义 AI 模型配置

### v1.2.0 (计划中)
- [ ] Web UI 界面
- [ ] 数据库持久化
- [ ] 协作功能
- [ ] 导出为 PDF/Word 格式

---

*最后更新: 2026-02-28*
