---
name: Scholar
description: Search academic literature with Google Scholar using effective queries, citations, and filters.
metadata: {"clawdbot":{"emoji":"🎓","os":["linux","darwin","win32"]}}
---

# Google Scholar Research Rules

## Query Construction
- Exact phrases in quotes: "machine learning" finds the phrase, not separate words
- Exclude terms with minus: neural networks -deep removes deep learning results
- OR for alternatives: "global warming" OR "climate change" — must be uppercase
- author: operator for specific researchers: author:"Y LeCun"
- source: for specific journals: source:"Nature" quantum computing
- intitle: forces term in title: intitle:transformer attention

## Time Filters
- Custom range critical for recent research — default shows highly cited old papers first
- "Since 2023" for cutting-edge but less vetted work
- "Since 2020" balances recency and citation accumulation
- Sort by date for newest, sort by relevance for most cited — toggle based on need

## Understanding Results
- Citation count indicates influence, not quality — popular isn't always right
- "Cited by X" link shows who built on this work — follow research forward
- "Related articles" finds similar work — useful after finding one good paper
- Versions link shows preprints and alternate copies — often free when journal isn't
- Quotation marks in snippet show exact matches — verify relevance before clicking

## Finding Full Text
- Check "All versions" for free copies — preprints, institutional repositories
- Add filetype:pdf to find direct PDF links
- Unpaywall browser extension auto-finds legal free versions
- Request from authors directly — most will share, academia.edu and ResearchGate common
- Institutional access through library proxy — VPN to university network

## Citation Analysis
- h-index visible on author profiles — measures productivity and impact
- "Cited by" sorted by relevance shows most influential citations
- Citation count alone misleads — review papers cite heavily but add less
- Self-citations inflate metrics — check who's actually citing
- Recent citations more meaningful for living research — old papers cited by habit

## Alerts and Tracking
- Create alerts for search terms — email when new papers match
- Follow researchers via profiles — notifications for new publications
- "Cite" button exports to reference managers — BibTeX, EndNote, RefMan
- Save to library requires Google account — organizes papers for later

## Limitations to Know
- Coverage biased toward English and STEM — humanities and non-English underrepresented
- No quality filter — predatory journals appear alongside legitimate ones
- Older papers may not be indexed — pre-digital era incomplete
- Cannot search full text — only titles, abstracts, and metadata
- Ranking algorithm opaque — not always clear why results ordered as shown

## Evaluating Sources
- Check journal reputation before trusting — impact factor as rough guide
- Preprints not peer-reviewed — valuable for speed, treat as preliminary
- Conference papers vary by field — top-tier in CS, lower status in medicine
- Retracted papers may still appear — verify paper status before citing
- Thesis and dissertations are gray literature — use cautiously

## Search Strategies
- Start broad, narrow with filters — missing papers worse than sorting many
- Combine Scholar with domain databases — PubMed for medicine, IEEE for engineering
- Snowball: find one good paper, explore its citations and references
- Check review papers for comprehensive coverage — synthesize existing knowledge
- Multiple queries with synonyms — terminology varies across disciplines

## Common Mistakes
- Trusting citation count as quality measure
- Ignoring publication date — fields evolve, old papers may be outdated
- Stopping at first page of results — good papers may be buried
- Not checking for retractions or corrections
- Citing papers based only on abstract — always read methodology
- Missing preprint versions that are freely available
