---
name: Schedule
slug: schedule
version: 1.0.2
description: Program recurring or one-time tasks. User defines what to do, skill handles when.
changelog: Clarified user-driven execution model, removed assumed access patterns
metadata: {"clawdbot":{"emoji":"📅","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Data Storage

```
~/schedule/
├── jobs.json           # Job definitions
├── preferences.json    # Timezone, preferred times
└── history/            # Execution logs
    └── YYYY-MM.jsonl
```

Create on first use: `mkdir -p ~/schedule/history`

## Scope

This skill:
- ✅ Stores scheduled job definitions in ~/schedule/
- ✅ Triggers jobs at specified times
- ✅ Learns timezone and time preferences from user

**Execution model:**
- User explicitly defines WHAT the job does
- User grants any permissions needed for the job
- Skill only handles WHEN, not WHAT

This skill does NOT:
- ❌ Assume access to any external service
- ❌ Modify system crontab or launchd
- ❌ Execute jobs without user-defined instructions

## Quick Reference

| Topic | File |
|-------|------|
| Cron expression syntax | `patterns.md` |
| Common mistakes | `traps.md` |
| Job format | `jobs.md` |

## Core Rules

### 1. User Defines Everything
When user requests a scheduled task:
1. **WHAT**: User specifies the action (may require other skills/permissions)
2. **WHEN**: This skill handles timing
3. **HOW**: User grants any needed access explicitly

Example flow:
```
User: "Every morning, summarize my emails"
Agent: "I'll schedule this for 8am. This will need email access — 
        do you want me to use the mail skill for this?"
User: "Yes"
→ Job stored with explicit reference to mail skill
```

### 2. Simple Requests
| Request | Action |
|---------|--------|
| "Remind me to X at Y" | Store job, confirm |
| "Every morning do X" | Ask time, store job |
| "Cancel X" | Remove from jobs.json |

### 3. Confirmation Format
```
✅ [what user requested]
📅 [when] ([timezone])
🔧 [permissions/skills needed, if any]
🆔 [id]
```

### 4. Job Persistence
In ~/schedule/jobs.json:
```json
{
  "daily_review": {
    "cron": "0 9 * * 1-5",
    "task": "User-defined task description",
    "requires": ["mail"],
    "created": "2024-03-15",
    "timezone": "Europe/Madrid"
  }
}
```

The `requires` field explicitly lists any skills/access the job needs.

### 5. Execution
When scheduled time arrives:
- Agent executes the user-defined task
- Uses only permissions user explicitly granted
- Logs result to history/

### 6. Preferences
After first job, store in preferences.json:
- Timezone
- Preferred "morning" / "evening" times
- Default notification style
